/*
 * Decompiled with CFR 0.152.
 */
package org.jocl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jocl.CL;
import org.jocl.LibTracker;
import org.jocl.LibUtils;

class LibInitializer {
    private static final Logger logger = Logger.getLogger(LibTracker.class.getName());
    private static final Level level = Level.FINE;

    static void initNativeLibrary() {
        String[] libCandidates = LibInitializer.createImplementationNameCandidates();
        boolean initialized = false;
        for (int i = 0; i < libCandidates.length && !initialized; ++i) {
            logger.log(level, "Trying library candidate: " + libCandidates[i]);
            initialized = CL.initNativeLibrary(libCandidates[i]);
            if (initialized) break;
        }
        if (!initialized) {
            throw new UnsatisfiedLinkError("Could not initialize native OpenCL library. Implementation library could not be loaded");
        }
    }

    private static String[] createImplementationNameCandidates() {
        String defaultLibName = LibUtils.createLibraryFileName("OpenCL");
        LibUtils.OSType osType = LibUtils.calculateOS();
        if (LibUtils.OSType.APPLE.equals((Object)osType)) {
            return new String[]{"/System/Library/Frameworks/OpenCL.framework/Versions/Current/OpenCL", defaultLibName};
        }
        if (LibUtils.OSType.ANDROID.equals((Object)osType)) {
            return new String[]{"/system/vendor/lib/libOpenCL.so", "/system/vendor/lib/egl/libGLES_mali.so", "/system/vendor/lib/libPVROCL.so", "/system/lib/libOpenCL.so", "/system/lib/egl/libGLES_mali.so", "/system/lib/libPVROCL.so", defaultLibName};
        }
        return new String[]{defaultLibName};
    }

    private LibInitializer() {
    }
}

