/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.jire.swiftfup.client.FileResponse;

public final class FileResponseDecoder
extends ByteToMessageDecoder {
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        byte[] data;
        if (!in.isReadable(6)) {
            return;
        }
        in.markReaderIndex();
        int filePair = in.readMedium();
        int dataSize = in.readUnsignedMedium();
        if (!in.isReadable(dataSize)) {
            in.resetReaderIndex();
            return;
        }
        byte[] byArray = data = dataSize > 0 ? new byte[dataSize] : null;
        if (data != null) {
            in.readBytes(data);
        }
        FileResponse fileResponse = new FileResponse(filePair, data);
        out.add(fileResponse);
    }
}

