/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jire.swiftfup.client.AutoProcessor;
import org.jire.swiftfup.client.FileChecksumsRequest;
import org.jire.swiftfup.client.FileChecksumsResponse;
import org.jire.swiftfup.client.FileClient;
import org.jire.swiftfup.client.FileDecompressedListener;
import org.jire.swiftfup.client.FileRequests;
import org.jire.swiftfup.client.FileStore;

public interface SwiftFUP {
    public FileRequests getFileRequests();

    public void setFileRequests(FileRequests var1);

    public FileClient getFileClient();

    public void setFileClient(FileClient var1);

    public FileStore getFileStore();

    public FileDecompressedListener getFileDecompressedListener();

    public AutoProcessor getAutoProcessor();

    default public int getExpectedRequests() {
        return 8192;
    }

    default public void startAutoProcessor() {
        AutoProcessor autoProcessor = this.getAutoProcessor();
        if (autoProcessor != null) {
            new Thread(() -> autoProcessor.autoProcessLoop(this.getFileRequests())).start();
        }
    }

    default public FileRequests initializeFileRequests() {
        FileRequests fileRequests = new FileRequests(this.getExpectedRequests(), this.getFileStore(), this.getFileDecompressedListener());
        this.setFileRequests(fileRequests);
        return fileRequests;
    }

    default public FileClient initializeFileClient(String host, int port) {
        FileClient fileClient = new FileClient(host, port, this.getFileRequests());
        this.setFileClient(fileClient);
        return fileClient;
    }

    default public void initializeSwiftFUP(String host, int port) {
        this.initializeFileRequests();
        FileClient fileClient = this.initializeFileClient(host, port);
        fileClient.connect();
        this.startAutoProcessor();
        this.initializeChecksums();
    }

    default public FileChecksumsResponse initializeChecksums() {
        return this.initializeChecksums(this.getFileClient(), this.getDefaultChecksumsTimeout(), this.getDefaultChecksumsTimeoutUnit());
    }

    default public int getDefaultChecksumsTimeout() {
        return 30;
    }

    default public TimeUnit getDefaultChecksumsTimeoutUnit() {
        return TimeUnit.SECONDS;
    }

    default public FileChecksumsResponse initializeChecksums(FileClient fileClient, int timeout2, TimeUnit timeoutTimeUnit) {
        FileChecksumsRequest fileChecksumsRequest = fileClient.requestChecksums();
        fileClient.flush();
        try {
            return (FileChecksumsResponse)fileChecksumsRequest.get(timeout2, timeoutTimeUnit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }
}

