/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client;

import org.jire.swiftfup.client.FilePair;
import org.jire.swiftfup.client.FileStore;

public final class FileResponse {
    private final int filePair;
    private final byte[] data;
    private volatile byte[] decompressedData;

    public FileResponse(int filePair, byte[] data) {
        this.filePair = filePair;
        this.data = data;
    }

    public int getFilePair() {
        return this.filePair;
    }

    public int getIndex() {
        return FilePair.index(this.filePair);
    }

    public int getFile() {
        return FilePair.file(this.filePair);
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getDecompressedData() {
        return this.decompressedData;
    }

    public void setDecompressedData(byte[] decompressedData) {
        this.decompressedData = decompressedData;
    }

    public byte[] setDecompressedData(FileStore fileStore) {
        byte[] data = this.getData();
        if (data == null || data.length < 1) {
            return null;
        }
        byte[] decompressedData = fileStore.decompress(data);
        this.setDecompressedData(decompressedData);
        return decompressedData;
    }
}

