/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueue;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.zip.CRC32;
import org.jire.swiftfup.client.FileChecksumsRequest;
import org.jire.swiftfup.client.FileChecksumsResponse;
import org.jire.swiftfup.client.FileClient;
import org.jire.swiftfup.client.FileDecompressedListener;
import org.jire.swiftfup.client.FileIndex;
import org.jire.swiftfup.client.FilePair;
import org.jire.swiftfup.client.FileRequest;
import org.jire.swiftfup.client.FileResponse;
import org.jire.swiftfup.client.FileStore;

public final class FileRequests {
    public static final Object MUTEX = new Object();
    private final int capacity;
    private final FileStore fileStore;
    private final Int2IntMap checksums;
    private final FileChecksumsRequest checksumsRequest = new FileChecksumsRequest();
    public final Int2ObjectMap<FileRequest> requests;
    private final MessagePassingQueue<FileResponse> completedResponses;
    private final MessagePassingQueue.Consumer<FileResponse> completedResponseConsumer;
    private final MessagePassingQueue<FileResponse> decompressedResponses;
    private final MessagePassingQueue.Consumer<FileResponse> decompressedResponseConsumer;
    private volatile boolean ignoreChecksums;
    private static final ThreadLocal<CRC32> threadLocalCRC32 = ThreadLocal.withInitial(CRC32::new);

    public FileRequests(int capacity, FileStore fileStore, FileDecompressedListener fileDecompressedListener) {
        this.capacity = capacity;
        this.fileStore = fileStore;
        this.checksums = new Int2IntOpenHashMap(capacity);
        this.checksumsRequest.thenAccept(response -> this.checksums.putAll(response.getFileToChecksum()));
        this.requests = new Int2ObjectOpenHashMap<FileRequest>(capacity);
        this.completedResponses = new MpscArrayQueue<FileResponse>(capacity);
        this.completedResponseConsumer = response -> {
            int filePair = response.getFilePair();
            FileRequest request = (FileRequest)this.requests.get(filePair);
            request.complete(response);
        };
        this.decompressedResponses = new MpscArrayQueue<FileResponse>(capacity);
        this.decompressedResponseConsumer = fileDecompressedListener::decompressed;
    }

    public FileChecksumsRequest checksums(FileClient fileClient) {
        if (!this.checksumsRequest.isDone()) {
            fileClient.request(this.checksumsRequest);
        }
        return this.checksumsRequest;
    }

    public FileRequest filePair(int filePair, FileClient fileClient) {
        boolean error;
        int index = FilePair.index(filePair);
        int file = FilePair.file(filePair);
        FileRequest request = (FileRequest)this.requests.get(filePair);
        if (request != null && request.isSent()) {
            FileResponse response2;
            if (index > 0 && (response2 = (FileResponse)request.getNow(null)) != null && response2.getDecompressedData() != null) {
                this.decompressedResponses.offer(response2);
            }
            return request;
        }
        request = new FileRequest(filePair);
        this.requests.put(filePair, request);
        boolean bl = error = fileClient.containsError(FilePair.file(filePair)) && FilePair.index(filePair) == 6;
        if (index > 0) {
            byte[] diskData = this.getDiskData(filePair);
            if (this.checksumMatches(filePair, diskData) && !error) {
                FileResponse response3 = new FileResponse(filePair, diskData);
                response3.setDecompressedData(this.fileStore);
                this.decompressedResponseConsumer.accept(response3);
                request.complete(response3);
                return request;
            }
            request.thenAccept(this::notifyDecompressed);
        }
        request.thenAccept(response -> {
            Object object = MUTEX;
            synchronized (object) {
                byte[] data = response.getData();
                if (data != null && data.length > 0) {
                    FileIndex fileIndex = this.fileStore.getIndex(index);
                    fileIndex.writeFile(file, data);
                }
            }
        });
        fileClient.request(request);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        FileRequests fileRequests = this;
        synchronized (fileRequests) {
            this.completedResponses.drain(this.completedResponseConsumer, this.capacity);
            this.decompressedResponses.drain(this.decompressedResponseConsumer, this.capacity);
        }
    }

    public void notifyChecksums(FileChecksumsResponse response) {
        this.checksumsRequest.complete(response);
    }

    public void notify(FileResponse response) {
        this.completedResponses.offer(response);
    }

    public void notifyDecompressed(FileResponse response) {
        response.setDecompressedData(this.fileStore);
        this.decompressedResponses.offer(response);
    }

    public boolean checksumMatches(int filePair, int checksum) {
        return this.checksums.get(filePair) == checksum;
    }

    public int getChecksum(int filePair) {
        return this.checksums.get(filePair);
    }

    public boolean checksum(int filePair, byte[] data) {
        return FileRequests.checksumMatchesData(this.getChecksum(filePair), data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDiskData(int filePair) {
        Object object = MUTEX;
        synchronized (object) {
            int index = FilePair.index(filePair);
            int file = FilePair.file(filePair);
            FileIndex fileIndex = this.fileStore.getIndex(index);
            return fileIndex == null ? null : fileIndex.getFile(file);
        }
    }

    public boolean isIgnoreChecksums() {
        return this.ignoreChecksums;
    }

    public void setIgnoreChecksums(boolean ignoreChecksums) {
        this.ignoreChecksums = ignoreChecksums;
    }

    public boolean checksumMatches(int filePair, byte[] data) {
        return this.isIgnoreChecksums() && data != null || FileRequests.checksumMatchesData(this.getChecksum(filePair), data);
    }

    public static boolean checksumMatchesData(int checksum, byte[] data) {
        int dataChecksum = FileRequests.getChecksum(data);
        return checksum == dataChecksum;
    }

    public static int getChecksum(byte[] data, CRC32 crc32) {
        if (data == null) {
            return 0;
        }
        crc32.reset();
        crc32.update(data, 0, data.length);
        return (int)crc32.getValue();
    }

    public static int getChecksum(byte[] data) {
        return FileRequests.getChecksum(data, threadLocalCRC32.get());
    }
}

