/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import org.jgroups.util.Util;

public class MulticastTest2 {
    protected static final InetAddress MCAST_ADDR;
    protected static final InetAddress BIND_ADDR;
    protected static final int MCAST_PORT = 7600;

    public static void main(String[] args2) throws Exception {
        MulticastSocket sock1 = MulticastTest2.create();
        MulticastSocket sock2 = MulticastTest2.create();
        System.out.printf("sock1: %s\nsock2: %s\n", sock1.getLocalSocketAddress(), sock2.getLocalSocketAddress());
        Util.close(sock1, sock2);
        sock1 = new MulticastSocket(7600);
        sock2 = new MulticastSocket(7600);
    }

    protected static MulticastSocket create() throws IOException {
        MulticastSocket sock = null;
        InetSocketAddress saddr = new InetSocketAddress(MCAST_ADDR, 7600);
        sock = new MulticastSocket(saddr);
        if (BIND_ADDR != null) {
            sock.setNetworkInterface(NetworkInterface.getByInetAddress(BIND_ADDR));
        }
        return sock;
    }

    static {
        try {
            MCAST_ADDR = InetAddress.getByName("228.8.8.8");
            BIND_ADDR = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

