/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jgroups.util.Util;

public class MakeUnique {
    int current_char = 65;
    int count = 0;

    void start(String inputfile, String outputfile, String delimiters, Collection<String> keywords, boolean dump) throws IOException {
        String input = inputfile != null ? Util.readFile(inputfile) : Util.readContents(System.in);
        Object delims = ",\n\r \t[]|:;";
        if (delimiters != null) {
            delims = (String)delims + delimiters;
        }
        StringTokenizer tok = new StringTokenizer(input, (String)delims, true);
        FileOutputStream output = new FileOutputStream(outputfile);
        HashMap<String, String> map = new HashMap<String, String>();
        while (tok.hasMoreTokens()) {
            String val;
            String token = tok.nextToken();
            if (token == null) continue;
            if (map.containsKey(token)) {
                val = (String)map.get(token);
                output.write(val.getBytes());
                System.out.print(val);
                continue;
            }
            if (keywords != null && MakeUnique.isKeyword(keywords, token)) {
                map.put(token, this.get());
                val = (String)map.get(token);
                output.write(val.getBytes());
                System.out.print(val);
                this.increment();
                continue;
            }
            output.write(token.getBytes());
            System.out.print(new String(token.getBytes()));
        }
        output.close();
        System.out.println("\noutput written to " + outputfile);
        if (dump) {
            System.out.println("map:");
            TreeMap<String, String> tmp = new TreeMap<String, String>();
            for (Map.Entry entry : map.entrySet()) {
                tmp.put((String)entry.getValue(), (String)entry.getKey());
            }
            for (Map.Entry entry : tmp.entrySet()) {
                System.out.println((String)entry.getKey() + ": \t" + (String)entry.getValue());
            }
        }
    }

    private String get() {
        if (this.current_char <= 90 && this.count == 0) {
            return String.valueOf((char)this.current_char);
        }
        return (char)this.current_char + String.valueOf(this.count);
    }

    private void increment() {
        if (++this.current_char > 90) {
            ++this.count;
            this.current_char = 65;
        }
    }

    static boolean isKeyword(Collection<String> keywords, String token) {
        for (String keyword : keywords) {
            if (!token.equals(keyword)) continue;
            return true;
        }
        for (String keyword : keywords) {
            if (!token.startsWith(keyword)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args2) throws IOException {
        String input = null;
        String output = "output.txt";
        String delims = null;
        HashSet<String> keywords = new HashSet<String>();
        boolean dump = false;
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i].equals("-in")) {
                input = args2[++i];
                continue;
            }
            if (args2[i].equals("-out")) {
                output = args2[++i];
                continue;
            }
            if (args2[i].equals("-delims")) {
                delims = args2[++i];
                continue;
            }
            if (args2[i].equals("-dump")) {
                dump = true;
                continue;
            }
            if (args2[i].equals("-h")) {
                System.out.println("MakeUnique -in inputfile [-out outputfile] [-delims delimiters] [keyword]*");
                return;
            }
            keywords.add(args2[i]);
        }
        new MakeUnique().start(input, output, delims, keywords, dump);
    }
}

