/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.xp;

import java.io.IOException;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XpClient {
    private static final Logger log = LoggerFactory.getLogger(XpClient.class);
    private final OkHttpClient client;

    public XpClient(OkHttpClient client) {
        this.client = client;
    }

    public void update(final String username) {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("xp").addPathSegment("update").addQueryParameter("username", username).build();
        Request request = new Request.Builder().url(url).build();
        this.client.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                log.warn("Error submitting xp track", e);
            }

            @Override
            public void onResponse(Call call, Response response) {
                response.close();
                log.debug("Submitted xp track for {}", (Object)username);
            }
        });
    }
}

