/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.config;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.config.Configuration;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigClient {
    private static final Logger log = LoggerFactory.getLogger(ConfigClient.class);
    private static final MediaType TEXT_PLAIN = MediaType.parse("text/plain");
    private static final Gson GSON = RuneLiteAPI.GSON;
    private final OkHttpClient client;
    private final UUID uuid;

    public Configuration get() throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("config").build();
        log.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().header("RUNELITE-AUTH", this.uuid.toString()).url(url).build();
        Response response = this.client.newCall(request).execute();
        try {
            InputStream in = response.body().byteStream();
            Configuration configuration = RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), Configuration.class);
            if (response != null) {
                response.close();
            }
            return configuration;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JsonParseException ex) {
                throw new IOException(ex);
            }
        }
    }

    public CompletableFuture<Void> set(final String key, final String value) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("config").addPathSegment(key).build();
        log.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().put(RequestBody.create(TEXT_PLAIN, value)).header("RUNELITE-AUTH", this.uuid.toString()).url(url).build();
        this.client.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                log.warn("Unable to synchronize configuration item", e);
                future.completeExceptionally(e);
            }

            @Override
            public void onResponse(Call call, Response response) {
                response.close();
                log.debug("Synchronized configuration value '{}' to '{}'", (Object)key, (Object)value);
                future.complete(null);
            }
        });
        return future;
    }

    public CompletableFuture<Void> patch(final Configuration configuration) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("config").build();
        log.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().patch(RequestBody.create(RuneLiteAPI.JSON, GSON.toJson(configuration))).header("RUNELITE-AUTH", this.uuid.toString()).url(url).build();
        this.client.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                log.warn("Unable to synchronize configuration item", e);
                future.completeExceptionally(e);
            }

            @Override
            public void onResponse(Call call, Response response) {
                if (response.code() != 200) {
                    String body = "bad response";
                    try {
                        body = response.body().string();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    log.warn("failed to synchronize some of {} configuration values: {}", (Object)configuration.getConfig().size(), (Object)body);
                } else {
                    log.debug("Synchronized {} configuration values", (Object)configuration.getConfig().size());
                }
                response.close();
                future.complete(null);
            }
        });
        return future;
    }

    public CompletableFuture<Void> unset(final String key) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("config").addPathSegment(key).build();
        log.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().delete().header("RUNELITE-AUTH", this.uuid.toString()).url(url).build();
        this.client.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                log.warn("Unable to unset configuration item", e);
                future.completeExceptionally(e);
            }

            @Override
            public void onResponse(Call call, Response response) {
                response.close();
                log.debug("Unset configuration value '{}'", (Object)key);
                future.complete(null);
            }
        });
        return future;
    }

    public ConfigClient(OkHttpClient client, UUID uuid) {
        this.client = client;
        this.uuid = uuid;
    }
}

