/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.utils.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class GpuFloatBuffer {
    private FloatBuffer buffer = GpuFloatBuffer.allocateDirect(65536);

    public void put(float texture, float u, float v, float pad) {
        this.buffer.put(texture).put(u).put(v).put(pad);
    }

    public void put(float[] floats) {
        this.buffer.put(floats);
    }

    public void flip() {
        this.buffer.flip();
    }

    public void clear() {
        this.buffer.clear();
    }

    public void ensureCapacity(int size) {
        int position;
        int capacity = this.buffer.capacity();
        if (capacity - (position = this.buffer.position()) < size) {
            while ((capacity *= 2) - position < size) {
            }
            FloatBuffer newB = GpuFloatBuffer.allocateDirect(capacity);
            this.buffer.flip();
            newB.put(this.buffer);
            this.buffer = newB;
        }
    }

    public FloatBuffer getBuffer() {
        return this.buffer;
    }

    public static FloatBuffer allocateDirect(int size) {
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }
}

