/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.utils;

public class Rect {
    private final int minX;
    private final int minY;
    private final int maxX;
    private final int maxY;
    private final int plane;

    public Rect(int pointAX, int pointAY, int pointBX, int pointBY) {
        this.minX = Math.min(pointAX, pointBX);
        this.minY = Math.min(pointAY, pointBY);
        this.maxX = Math.max(pointAX, pointBX);
        this.maxY = Math.max(pointAY, pointBY);
        this.plane = -1;
    }

    public Rect(int pointAX, int pointAY, int pointBX, int pointBY, int plane) {
        this.minX = Math.min(pointAX, pointBX);
        this.minY = Math.min(pointAY, pointBY);
        this.maxX = Math.max(pointAX, pointBX);
        this.maxY = Math.max(pointAY, pointBY);
        this.plane = plane;
    }

    public boolean containsPoint(int pointX, int pointY, int pointZ) {
        return pointX <= this.maxX && pointX >= this.minX && pointY <= this.maxY && pointY >= this.minY && (this.plane == -1 || this.plane == pointZ);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getPlane() {
        return this.plane;
    }
}

