/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.utils;

import java.awt.event.KeyEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import javax.inject.Inject;
import net.runelite.client.config.Keybind;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.hd.HdPlugin;
import net.runelite.client.plugins.hd.HdPluginConfig;
import net.runelite.client.plugins.hd.opengl.shader.Template;
import net.runelite.client.plugins.hd.overlays.TileInfoOverlay;
import net.runelite.client.plugins.hd.utils.Env;
import net.runelite.client.plugins.hd.utils.FileWatcher;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeveloperTools
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(DeveloperTools.class);
    public static final String ENV_SHADER_PATH = "RLHD_SHADER_PATH";
    private static final Keybind KEY_TOGGLE_TILE_INFO = new Keybind(114, 128);
    @Inject
    private HdPluginConfig config;
    @Inject
    private HdPlugin plugin;
    @Inject
    private KeyManager keyManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TileInfoOverlay tileInfoOverlay;
    private Path shaderPath;
    private FileWatcher shaderSourceWatcher;
    private boolean tileInfoOverlayEnabled = false;

    public void activate() {
        this.keyManager.registerKeyListener(this);
        if (this.tileInfoOverlayEnabled) {
            this.overlayManager.add(this.tileInfoOverlay);
        }
        this.shaderPath = Env.getPath(ENV_SHADER_PATH);
        if (this.shaderPath != null) {
            try {
                this.shaderSourceWatcher = new FileWatcher().watchPath(this.shaderPath).addChangeHandler(path -> {
                    if (path.getFileName().toString().endsWith(".glsl")) {
                        log.info("Reloading shaders...");
                        this.plugin.recompilePrograms();
                    }
                });
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void deactivate() {
        if (this.shaderSourceWatcher != null) {
            this.shaderSourceWatcher.close();
            this.shaderSourceWatcher = null;
        }
        this.keyManager.unregisterKeyListener(this);
        this.overlayManager.remove(this.tileInfoOverlay);
    }

    public String shaderResolver(String path) {
        Path fullPath = this.shaderPath.resolve(path);
        try {
            log.debug("Loading shader from file: {}", (Object)fullPath);
            return Template.inputStreamToString(new FileInputStream(fullPath.toFile()));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("Failed to load shader from file: " + fullPath, ex);
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (KEY_TOGGLE_TILE_INFO.matches(event)) {
            event.consume();
            boolean bl = this.tileInfoOverlayEnabled = !this.tileInfoOverlayEnabled;
            if (this.tileInfoOverlayEnabled) {
                this.overlayManager.add(this.tileInfoOverlay);
            } else {
                this.overlayManager.remove(this.tileInfoOverlay);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }
}

