/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.scene.lighting;

import com.google.common.collect.ListMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.runelite.client.plugins.hd.scene.lighting.Light;
import net.runelite.client.plugins.hd.scene.lighting.SceneLight;
import net.runelite.client.plugins.hd.utils.HDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightConfig {
    private static final Logger log = LoggerFactory.getLogger(LightConfig.class);

    public static void load(ArrayList<SceneLight> worldLights, ListMultimap<Integer, Light> npcLights, ListMultimap<Integer, Light> objectLights, ListMultimap<Integer, Light> projectileLights) {
        String filename = "lights.json";
        InputStream is = LightConfig.class.getResourceAsStream(filename);
        if (is == null) {
            throw new RuntimeException("Missing resource: " + Paths.get(LightConfig.class.getPackage().getName().replace(".", "/"), filename));
        }
        LightConfig.load(is, worldLights, npcLights, objectLights, projectileLights);
    }

    public static void load(File jsonFile, ArrayList<SceneLight> worldLights, ListMultimap<Integer, Light> npcLights, ListMultimap<Integer, Light> objectLights, ListMultimap<Integer, Light> projectileLights) {
        try {
            LightConfig.load(new FileInputStream(jsonFile), worldLights, npcLights, objectLights, projectileLights);
        }
        catch (IOException ex) {
            log.error("Lights config file not found: " + jsonFile.toPath() + ". Falling back to default config...", ex);
            LightConfig.load(worldLights, npcLights, objectLights, projectileLights);
        }
    }

    public static void load(InputStream jsonInputStream, ArrayList<SceneLight> worldLights, ListMultimap<Integer, Light> npcLights, ListMultimap<Integer, Light> objectLights, ListMultimap<Integer, Light> projectileLights) {
        try {
            Light[] lights;
            for (Light l : lights = LightConfig.loadRawLights(jsonInputStream)) {
                float[] linearRGBA = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
                for (int i = 0; i < Math.min(l.color.length, linearRGBA.length); ++i) {
                    int n = i;
                    float f = l.color[n] / 255.0f;
                    l.color[n] = f;
                    linearRGBA[i] = HDUtils.gammaToLinear(f);
                }
                l.color = linearRGBA;
                if (l.worldX != null && l.worldY != null) {
                    worldLights.add(new SceneLight(l));
                }
                l.npcIds.forEach(id -> npcLights.put((Integer)id, l));
                l.objectIds.forEach(id -> objectLights.put((Integer)id, l));
                l.projectileIds.forEach(id -> projectileLights.put((Integer)id, l));
            }
            log.info("Loaded {} lights", (Object)lights.length);
        }
        catch (Exception ex) {
            log.error("Failed to parse light configuration", ex);
        }
    }

    public static Light[] loadRawLights(InputStream is) {
        InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
        Gson gson = new GsonBuilder().setLenient().create();
        return gson.fromJson((Reader)reader, Light[].class);
    }
}

