/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.scene.lighting;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.runelite.client.plugins.hd.data.NpcID;
import net.runelite.client.plugins.hd.data.ObjectID;
import net.runelite.client.plugins.hd.scene.lighting.Alignment;
import net.runelite.client.plugins.hd.scene.lighting.LightType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Light {
    private static final Logger log = LoggerFactory.getLogger(Light.class);
    @VisibleForTesting
    public static boolean THROW_WHEN_PARSING_FAILS = false;
    public String description;
    public Integer worldX;
    public Integer worldY;
    public Integer plane;
    public Integer height;
    public Alignment alignment;
    public int radius;
    public float strength;
    public float[] color;
    public LightType type;
    public float duration;
    public float range;
    public Integer fadeInDuration;
    @JsonAdapter(value=NpcIDAdapter.class)
    public HashSet<Integer> npcIds;
    @JsonAdapter(value=ObjectIDAdapter.class)
    public HashSet<Integer> objectIds;
    @JsonAdapter(value=ProjectileIDAdapter.class)
    public HashSet<Integer> projectileIds;

    public Light() {
        this.npcIds = new HashSet();
        this.objectIds = new HashSet();
        this.projectileIds = new HashSet();
    }

    public Light(String description, Integer worldX, Integer worldY, Integer plane, Integer height, Alignment alignment, int radius, float strength, float[] color, LightType type, float duration, float range, Integer fadeInDuration, HashSet<Integer> npcIds, HashSet<Integer> objectIds, HashSet<Integer> projectileIds) {
        this.description = description;
        this.worldX = worldX;
        this.worldY = worldY;
        this.plane = plane;
        this.height = height;
        this.alignment = alignment;
        this.radius = radius;
        this.strength = strength;
        this.color = color;
        this.type = type;
        this.duration = duration;
        this.range = range;
        this.fadeInDuration = fadeInDuration;
        this.npcIds = npcIds == null ? new HashSet() : npcIds;
        this.objectIds = objectIds == null ? new HashSet() : objectIds;
        this.projectileIds = projectileIds == null ? new HashSet() : projectileIds;
    }

    private static HashSet<Integer> parseIDArray(JsonReader in, @Nullable Class<?> idContainer) throws IOException {
        HashSet<Integer> ids = new HashSet<Integer>();
        in.beginArray();
        while (in.hasNext()) {
            switch (in.peek()) {
                case NUMBER: {
                    String message2;
                    try {
                        ids.add(in.nextInt());
                    }
                    catch (NumberFormatException ex) {
                        message2 = "Failed to parse int";
                        if (THROW_WHEN_PARSING_FAILS) {
                            throw new RuntimeException(message2, ex);
                        }
                        log.error(message2, ex);
                    }
                    break;
                }
                case STRING: {
                    String message;
                    String message2;
                    String fieldName = in.nextString();
                    if (idContainer == null) {
                        message2 = String.format("String '%s' is not supported here", fieldName);
                        if (THROW_WHEN_PARSING_FAILS) {
                            throw new RuntimeException(message2);
                        }
                        log.error(message2);
                        break;
                    }
                    try {
                        Field field = idContainer.getField(fieldName);
                        if (!field.getType().equals(Integer.TYPE)) {
                            message = String.format("%s field '%s' is not an int", idContainer.getName(), fieldName);
                            if (THROW_WHEN_PARSING_FAILS) {
                                throw new RuntimeException(message);
                            }
                            log.error(message);
                            break;
                        }
                        ids.add(field.getInt(null));
                        break;
                    }
                    catch (NoSuchFieldException ex) {
                        message = String.format("Missing %s: %s", idContainer.getName(), fieldName);
                        if (THROW_WHEN_PARSING_FAILS) {
                            throw new RuntimeException(message, ex);
                        }
                        log.error(message, ex);
                        break;
                    }
                    catch (IllegalAccessException ex) {
                        message = String.format("Unable to access %s field: %s", idContainer.getName(), fieldName);
                        if (THROW_WHEN_PARSING_FAILS) {
                            throw new RuntimeException(message, ex);
                        }
                        log.error(message, ex);
                    }
                }
            }
        }
        in.endArray();
        return ids;
    }

    private static void writeIDArray(JsonWriter out, HashSet<Integer> listToWrite, @Nullable Class<?> idContainer) throws IOException {
        if (listToWrite.size() == 0) {
            out.nullValue();
            return;
        }
        if (idContainer == null) {
            out.beginArray();
            for (int i : listToWrite) {
                out.value(i);
            }
            out.endArray();
            return;
        }
        HashMap<Integer, String> idNames = new HashMap<Integer, String>();
        for (Field field : idContainer.getFields()) {
            if (!field.getType().equals(Integer.TYPE)) continue;
            try {
                int value = field.getInt(null);
                idNames.put(value, field.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        out.beginArray();
        Iterator<Integer> iterator2 = listToWrite.iterator();
        while (iterator2.hasNext()) {
            int id = (Integer)iterator2.next();
            String name = (String)idNames.get(id);
            if (name == null) {
                out.value(id);
                continue;
            }
            out.value(name);
        }
        out.endArray();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Light)) {
            return false;
        }
        Light other = (Light)obj;
        return other.description.equals(this.description) && Light.equal(other.worldX, this.worldX) && Light.equal(other.worldY, this.worldY) && Light.equal(other.plane, this.plane) && Light.equal(other.height, this.height) && other.alignment == this.alignment && other.radius == this.radius && other.strength == this.strength && Arrays.equals(other.color, this.color) && other.type == this.type && other.duration == this.duration && other.range == this.range && Light.equal(other.fadeInDuration, this.fadeInDuration) && other.npcIds.equals(this.npcIds) && other.objectIds.equals(this.objectIds) && other.projectileIds.equals(this.projectileIds);
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 37 + this.description.hashCode();
        hash = hash * 37 + (this.worldX == null ? 0 : this.worldX);
        hash = hash * 37 + (this.worldY == null ? 0 : this.worldY);
        hash = hash * 37 + (this.plane == null ? 0 : this.plane);
        hash = hash * 37 + (this.height == null ? 0 : this.height);
        hash = hash * 37 + (this.alignment == null ? 0 : this.alignment.hashCode());
        hash = hash * 37 + this.radius;
        hash = hash * 37 + (int)this.strength;
        for (float f : this.color) {
            hash = hash * 37 + (int)f;
        }
        hash = hash * 37 + (this.type == null ? 0 : this.type.hashCode());
        hash = hash * 37 + (int)this.duration;
        hash = hash * 37 + (int)this.range;
        hash = hash * 37 + (this.fadeInDuration == null ? 0 : this.fadeInDuration);
        hash = hash * 37 + this.npcIds.hashCode();
        hash = hash * 37 + this.objectIds.hashCode();
        hash = hash * 37 + this.projectileIds.hashCode();
        return hash;
    }

    private static boolean equal(Integer a, Integer b) {
        if (a != null && b != null) {
            return a.equals(b);
        }
        return a == null && b == null;
    }

    public static class ProjectileIDAdapter
    extends TypeAdapter<HashSet<Integer>> {
        @Override
        public void write(JsonWriter out, HashSet<Integer> value) throws IOException {
            Light.writeIDArray(out, value, null);
        }

        @Override
        public HashSet<Integer> read(JsonReader in) throws IOException {
            return Light.parseIDArray(in, null);
        }
    }

    public static class ObjectIDAdapter
    extends TypeAdapter<HashSet<Integer>> {
        @Override
        public void write(JsonWriter out, HashSet<Integer> value) throws IOException {
            Light.writeIDArray(out, value, ObjectID.class);
        }

        @Override
        public HashSet<Integer> read(JsonReader in) throws IOException {
            return Light.parseIDArray(in, ObjectID.class);
        }
    }

    public static class NpcIDAdapter
    extends TypeAdapter<HashSet<Integer>> {
        @Override
        public void write(JsonWriter out, HashSet<Integer> value) throws IOException {
            Light.writeIDArray(out, value, NpcID.class);
        }

        @Override
        public HashSet<Integer> read(JsonReader in) throws IOException {
            return Light.parseIDArray(in, NpcID.class);
        }
    }
}

