/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.overlays;

import com.google.inject.Inject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.plugins.hd.data.materials.Material;
import net.runelite.client.plugins.hd.data.materials.Underlay;
import net.runelite.client.plugins.hd.utils.HDUtils;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.apache.commons.lang3.tuple.Pair;

public class TileInfoOverlay
extends Overlay {
    private final Client client;
    private Point mousePos;

    @Inject
    public TileInfoOverlay(Client client) {
        this.client = client;
    }

    @Override
    public Dimension render(Graphics2D g2) {
        this.mousePos = this.client.getMouseCanvasPosition();
        if (this.mousePos != null && this.mousePos.getX() == -1 && this.mousePos.getY() == -1) {
            return null;
        }
        g2.setStroke(new BasicStroke(1.0f, 0, 1));
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        for (int plane = this.client.getPlane(); plane >= 0; --plane) {
            for (int isBridge = 1; isBridge >= 0; --isBridge) {
                for (int x = 0; x < 104; ++x) {
                    for (int y = 0; y < 104; ++y) {
                        boolean shouldDraw;
                        Tile tile = tiles[plane][x][y];
                        boolean bl = shouldDraw = tile != null && (isBridge == 0 || tile.getBridge() != null);
                        if (!shouldDraw || !this.drawTileInfo(g2, tile)) continue;
                        return null;
                    }
                }
            }
        }
        return null;
    }

    private boolean drawTileInfo(Graphics2D g2, Tile tile) {
        boolean infoDrawn = false;
        if (tile != null) {
            Polygon poly;
            Rectangle rect = null;
            Tile bridge = tile.getBridge();
            if (bridge != null && (poly = TileInfoOverlay.getCanvasTilePoly(this.client, bridge)) != null && poly.contains(this.mousePos.getX(), this.mousePos.getY()) && (rect = this.drawTileInfo(g2, bridge, poly, rect)) != null) {
                infoDrawn = true;
            }
            if ((poly = TileInfoOverlay.getCanvasTilePoly(this.client, tile)) != null && poly.contains(this.mousePos.getX(), this.mousePos.getY()) && (rect = this.drawTileInfo(g2, tile, poly, rect)) != null) {
                infoDrawn = true;
            }
        }
        return infoDrawn;
    }

    private Rectangle drawTileInfo(Graphics2D g2, Tile tile, Polygon poly, Rectangle dodgeRect) {
        Color polyColor;
        SceneTilePaint paint = tile.getSceneTilePaint();
        SceneTileModel model = tile.getSceneTileModel();
        if ((paint == null || paint.getNeColor() == 12345678 && tile.getBridge() == null) && model == null) {
            return null;
        }
        Rectangle2D polyBounds = poly.getBounds2D();
        Point tileCenter = new Point((int)polyBounds.getCenterX(), (int)polyBounds.getCenterY());
        ArrayList<String> lines = new ArrayList<String>();
        if (tile.getBridge() != null) {
            lines.add("Bridge");
        }
        int x = tile.getSceneLocation().getX();
        int y = tile.getSceneLocation().getY();
        int plane = tile.getRenderLevel();
        Scene scene = this.client.getScene();
        byte overlayId = scene.getOverlayIds()[plane][x][y];
        net.runelite.client.plugins.hd.data.materials.Overlay overlay = net.runelite.client.plugins.hd.data.materials.Overlay.getOverlay(overlayId, tile, this.client);
        lines.add(String.format("Overlay: %s (%d)", overlay.name(), (int)overlayId));
        byte underlayId = scene.getOverlayIds()[plane][x][y];
        Underlay underlay = Underlay.getUnderlay(underlayId, tile, this.client);
        lines.add(String.format("Underlay: %s (%d)", underlay.name(), (int)underlayId));
        if (paint != null) {
            polyColor = Color.CYAN;
            lines.add("Tile type: Paint");
            lines.add("RGB: " + (paint.getNeColor() == 12345678 ? "Hidden" : Arrays.toString(HDUtils.colorIntToRGB(paint.getRBG()))));
            Material material = Material.getTexture(paint.getTexture());
            lines.add(String.format("Material: %s (%d)", material.name(), paint.getTexture()));
        } else {
            polyColor = Color.ORANGE;
            lines.add("Tile type: Model");
            lines.add(String.format("Face count: %d", model.getFaceX().length));
            HashSet<String> uniqueMaterials = new HashSet<String>();
            int numChars = 0;
            if (model.getTriangleTextureId() != null) {
                for (int texture : model.getTriangleTextureId()) {
                    String material = String.format("%s (%d)", Material.getTexture(texture).name(), texture);
                    boolean unique = uniqueMaterials.add(material);
                    if (!unique) continue;
                    numChars += material.length();
                }
            }
            ArrayList materials = new ArrayList(uniqueMaterials);
            Collections.sort(materials);
            if (materials.size() <= 1 || numChars < 26) {
                StringBuilder sb = new StringBuilder("Materials: { ");
                if (materials.size() == 0) {
                    sb.append("null");
                } else {
                    String prefix = "";
                    for (String m3 : materials) {
                        sb.append(prefix).append(m3);
                        prefix = ", ";
                    }
                }
                sb.append(" }");
                lines.add(sb.toString());
            } else {
                Iterator iter = materials.iterator();
                lines.add("Materials: { " + (String)iter.next() + ",");
                while (iter.hasNext()) {
                    lines.add("\t  " + (String)iter.next() + (iter.hasNext() ? "," : " }"));
                }
            }
        }
        int padding = 4;
        int xPadding = padding * 2;
        int yPadding = padding;
        FontMetrics fm = g2.getFontMetrics();
        int lineHeight = fm.getHeight();
        int totalHeight = lineHeight * lines.size() + yPadding * 3;
        int space = fm.charWidth(':');
        int indent = fm.stringWidth("{ ");
        int leftWidth = 0;
        int rightWidth = 0;
        Function<String, Pair> splitter = line -> {
            int i = line.indexOf(":");
            String left = line;
            String right = "";
            if (i != -1) {
                left = line.substring(0, i);
                right = line.substring(i + 1);
            } else if (left.startsWith("\t")) {
                right = left;
                left = "";
            }
            return Pair.of(left, right);
        };
        for (String line2 : lines) {
            Pair pair = splitter.apply(line2);
            if (((String)pair.getRight()).length() == 0) {
                int halfWidth = fm.stringWidth((String)pair.getLeft()) / 2;
                leftWidth = Math.max(leftWidth, halfWidth);
                rightWidth = Math.max(rightWidth, halfWidth);
                continue;
            }
            leftWidth = Math.max(leftWidth, fm.stringWidth((String)pair.getLeft()));
            rightWidth = Math.max(rightWidth, fm.stringWidth((String)pair.getRight()));
        }
        int totalWidth = leftWidth + rightWidth + space + xPadding * 2;
        Rectangle rect = new Rectangle(tileCenter.getX() - totalWidth / 2, tileCenter.getY() - totalHeight - yPadding, totalWidth, totalHeight);
        if (dodgeRect != null && dodgeRect.intersects(rect)) {
            rect.y = dodgeRect.y - rect.height - yPadding;
        }
        if (tile.getBridge() != null) {
            polyColor = Color.MAGENTA;
        }
        g2.setColor(polyColor);
        g2.drawPolygon(poly);
        g2.setColor(new Color(0, 0, 0, 150));
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        int offsetY = 0;
        for (String line3 : lines) {
            Pair pair = splitter.apply(line3);
            Point p = ((String)pair.getRight()).length() == 0 ? new Point(rect.x + rect.width / 2 - fm.stringWidth((String)pair.getLeft()) / 2, rect.y + yPadding + offsetY) : new Point(rect.x + xPadding + leftWidth - fm.stringWidth((String)pair.getLeft()) + (((String)pair.getRight()).startsWith("\t") ? indent : 0), rect.y + yPadding + (offsetY += lineHeight));
            OverlayUtil.renderTextLocation(g2, p, line3, Color.WHITE);
        }
        return rect;
    }

    public static Polygon getCanvasTilePoly(@Nonnull Client client, Tile tile) {
        LocalPoint localLocation = tile.getLocalLocation();
        int plane = tile.getRenderLevel();
        if (!localLocation.isInScene()) {
            return null;
        }
        int swX = localLocation.getX() - 64;
        int swY = localLocation.getY() - 64;
        int neX = localLocation.getX() + 64;
        int neY = localLocation.getY() + 64;
        int swHeight = TileInfoOverlay.getHeight(client, swX, swY, plane);
        int nwHeight = TileInfoOverlay.getHeight(client, neX, swY, plane);
        int neHeight = TileInfoOverlay.getHeight(client, neX, neY, plane);
        int seHeight = TileInfoOverlay.getHeight(client, swX, neY, plane);
        Point p1 = Perspective.localToCanvas(client, swX, swY, swHeight);
        Point p2 = Perspective.localToCanvas(client, neX, swY, nwHeight);
        Point p3 = Perspective.localToCanvas(client, neX, neY, neHeight);
        Point p4 = Perspective.localToCanvas(client, swX, neY, seHeight);
        if (p1 == null || p2 == null || p3 == null || p4 == null) {
            return null;
        }
        Polygon poly = new Polygon();
        poly.addPoint(p1.getX(), p1.getY());
        poly.addPoint(p2.getX(), p2.getY());
        poly.addPoint(p3.getX(), p3.getY());
        poly.addPoint(p4.getX(), p4.getY());
        return poly;
    }

    private static int getHeight(@Nonnull Client client, int localX, int localY, int plane) {
        int sceneX = localX >> 7;
        int sceneY = localY >> 7;
        if (sceneX >= 0 && sceneY >= 0 && sceneX < 104 && sceneY < 104) {
            int[][][] tileHeights = client.getTileHeights();
            int x = localX & 0x7F;
            int y = localY & 0x7F;
            int var8 = x * tileHeights[plane][sceneX + 1][sceneY] + (128 - x) * tileHeights[plane][sceneX][sceneY] >> 7;
            int var9 = tileHeights[plane][sceneX][sceneY + 1] * (128 - x) + x * tileHeights[plane][sceneX + 1][sceneY + 1] >> 7;
            return (128 - y) * var8 + y * var9 >> 7;
        }
        return 0;
    }
}

