/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.opengl.shader;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Template {
    private static final Logger log = LoggerFactory.getLogger(Template.class);
    private final List<Function<String, String>> resourceLoaders = new ArrayList<Function<String, String>>();

    public String process(String str) {
        StringBuilder sb = new StringBuilder();
        for (String line : str.split("\r?\n")) {
            String trimmed = line.trim();
            if (trimmed.startsWith("#include ")) {
                String resource = trimmed.substring(9);
                String resourceStr = this.load(resource);
                sb.append(resourceStr);
                continue;
            }
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    public String load(String filename) {
        for (Function<String, String> loader : this.resourceLoaders) {
            String value = loader.apply(filename);
            if (value == null) continue;
            return this.process(value);
        }
        return "";
    }

    public Template add(Function<String, String> fn) {
        this.resourceLoaders.add(fn);
        return this;
    }

    public Template addInclude(Class<?> clazz) {
        return this.add(f -> {
            try (InputStream is = clazz.getResourceAsStream((String)f);){
                if (is == null) return null;
                String string = Template.inputStreamToString(is);
                return string;
            }
            catch (IOException ex) {
                log.warn(null, ex);
            }
            return null;
        });
    }

    public static String inputStreamToString(InputStream in) {
        try {
            return CharStreams.toString(new InputStreamReader(in, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

