/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.model;

import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GraphicsObject;
import net.runelite.api.Model;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Renderable;
import net.runelite.api.Tile;
import net.runelite.api.kit.KitType;
import net.runelite.client.plugins.hd.HdPlugin;
import net.runelite.client.plugins.hd.HdPluginConfig;
import net.runelite.client.plugins.hd.data.BakedModels;
import net.runelite.client.plugins.hd.data.materials.Material;
import net.runelite.client.plugins.hd.data.materials.Overlay;
import net.runelite.client.plugins.hd.data.materials.Underlay;
import net.runelite.client.plugins.hd.data.materials.UvType;
import net.runelite.client.plugins.hd.model.ModelCache;
import net.runelite.client.plugins.hd.model.ModelData;
import net.runelite.client.plugins.hd.model.objects.ObjectProperties;
import net.runelite.client.plugins.hd.model.objects.ObjectType;
import net.runelite.client.plugins.hd.model.objects.TzHaarRecolorType;
import net.runelite.client.plugins.hd.scene.ProceduralGenerator;
import net.runelite.client.plugins.hd.utils.HDUtils;
import net.runelite.client.plugins.hd.utils.buffer.GpuFloatBuffer;
import net.runelite.client.plugins.hd.utils.buffer.GpuIntBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ModelPusher {
    private static final Logger log = LoggerFactory.getLogger(ModelPusher.class);
    @Inject
    private HdPlugin hdPlugin;
    @Inject
    private HdPluginConfig config;
    @Inject
    private Client client;
    @Inject
    private ProceduralGenerator proceduralGenerator;
    private static final int ignoreLowLightness = 3;
    private static final float lightnessMultiplier = 3.0f;
    private static final int baseLighten = 10;
    private static final float[] zeroFloats = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private static final int[] twoInts = new int[2];
    private static final int[] fourInts = new int[4];
    private static final int[] eightInts = new int[8];
    private static final int[] twelveInts = new int[12];
    private static final float[] twelveFloats = new float[12];
    private static final int[] modelColors = new int[32768];
    private static final ModelData tempModelData = new ModelData();
    private final Map<Integer, ModelData> modelCache = new ModelCache(4096);

    public void clearModelCache() {
        this.modelCache.clear();
    }

    public int[] pushModel(Renderable renderable, Model model, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer, GpuFloatBuffer normalBuffer, int tileX, int tileY, int tileZ, ObjectProperties objectProperties, ObjectType objectType, boolean noCache, int hash) {
        int faceCount = Math.min(model.getFaceCount(), 8192);
        vertexBuffer.ensureCapacity(24 * faceCount);
        normalBuffer.ensureCapacity(24 * faceCount);
        uvBuffer.ensureCapacity(24 * faceCount);
        ModelData modelData = this.getCachedModelData(renderable, model, objectProperties, objectType, tileX, tileY, tileZ, faceCount, noCache, hash);
        int vertexLength = 0;
        int uvLength = 0;
        for (int face = 0; face < faceCount; ++face) {
            vertexBuffer.put(this.getVertexDataForFace(model, modelData, face));
            vertexLength += 3;
            normalBuffer.put(this.getNormalDataForFace(model, objectProperties, face));
            float[] uvData = this.getUvDataForFace(model, objectProperties, face);
            if (uvData == null) continue;
            uvBuffer.put(uvData);
            uvLength += 3;
        }
        ModelPusher.twoInts[0] = vertexLength;
        ModelPusher.twoInts[1] = uvLength;
        return twoInts;
    }

    private int[] getVertexDataForFace(Model model, ModelData modelData, int face) {
        int[] xVertices = model.getVerticesX();
        int[] yVertices = model.getVerticesY();
        int[] zVertices = model.getVerticesZ();
        int triA = model.getFaceIndices1()[face];
        int triB = model.getFaceIndices2()[face];
        int triC = model.getFaceIndices3()[face];
        ModelPusher.twelveInts[0] = xVertices[triA];
        ModelPusher.twelveInts[1] = yVertices[triA];
        ModelPusher.twelveInts[2] = zVertices[triA];
        ModelPusher.twelveInts[3] = modelData.getColorForFace(face, 3) | modelData.getColorForFace(face, 0);
        ModelPusher.twelveInts[4] = xVertices[triB];
        ModelPusher.twelveInts[5] = yVertices[triB];
        ModelPusher.twelveInts[6] = zVertices[triB];
        ModelPusher.twelveInts[7] = modelData.getColorForFace(face, 3) | modelData.getColorForFace(face, 1);
        ModelPusher.twelveInts[8] = xVertices[triC];
        ModelPusher.twelveInts[9] = yVertices[triC];
        ModelPusher.twelveInts[10] = zVertices[triC];
        ModelPusher.twelveInts[11] = modelData.getColorForFace(face, 3) | modelData.getColorForFace(face, 2);
        return twelveInts;
    }

    private float[] getNormalDataForFace(Model model, ObjectProperties objectProperties, int face) {
        if (model.getFaceColors3()[face] == -1 || objectProperties != null && objectProperties.isFlatNormals()) {
            return zeroFloats;
        }
        int triA = model.getFaceIndices1()[face];
        int triB = model.getFaceIndices2()[face];
        int triC = model.getFaceIndices3()[face];
        int[] xVertexNormals = model.getVertexNormalsX();
        int[] yVertexNormals = model.getVertexNormalsY();
        int[] zVertexNormals = model.getVertexNormalsZ();
        ModelPusher.twelveFloats[0] = xVertexNormals[triA];
        ModelPusher.twelveFloats[1] = yVertexNormals[triA];
        ModelPusher.twelveFloats[2] = zVertexNormals[triA];
        ModelPusher.twelveFloats[3] = 0.0f;
        ModelPusher.twelveFloats[4] = xVertexNormals[triB];
        ModelPusher.twelveFloats[5] = yVertexNormals[triB];
        ModelPusher.twelveFloats[6] = zVertexNormals[triB];
        ModelPusher.twelveFloats[7] = 0.0f;
        ModelPusher.twelveFloats[8] = xVertexNormals[triC];
        ModelPusher.twelveFloats[9] = yVertexNormals[triC];
        ModelPusher.twelveFloats[10] = zVertexNormals[triC];
        ModelPusher.twelveFloats[11] = 0.0f;
        return twelveFloats;
    }

    private float[] getUvDataForFace(Model model, ObjectProperties objectProperties, int face) {
        short[] faceTextures = model.getFaceTextures();
        float[] uv = model.getFaceTextureUVCoordinates();
        Material material = null;
        if (objectProperties != null && objectProperties.getMaterial() != Material.NONE) {
            Material material2 = material = this.hdPlugin.configObjectTextures ? objectProperties.getMaterial() : Material.NONE;
        }
        if (faceTextures != null && faceTextures[face] != -1 && uv != null) {
            material = this.proceduralGenerator.getSeasonalMaterial(Material.getTexture(faceTextures[face]));
            int packedMaterialData = this.packMaterialData(Material.getIndexFromDiffuseID(material.getDiffuseMapId()), false);
            int idx = face * 6;
            ModelPusher.twelveFloats[0] = packedMaterialData;
            ModelPusher.twelveFloats[1] = uv[idx];
            ModelPusher.twelveFloats[2] = uv[idx + 1];
            ModelPusher.twelveFloats[3] = 0.0f;
            ModelPusher.twelveFloats[4] = packedMaterialData;
            ModelPusher.twelveFloats[5] = uv[idx + 2];
            ModelPusher.twelveFloats[6] = uv[idx + 3];
            ModelPusher.twelveFloats[7] = 0.0f;
            ModelPusher.twelveFloats[8] = packedMaterialData;
            ModelPusher.twelveFloats[9] = uv[idx + 4];
            ModelPusher.twelveFloats[10] = uv[idx + 5];
            ModelPusher.twelveFloats[11] = 0.0f;
            return twelveFloats;
        }
        if (material != null) {
            int triA = model.getFaceIndices1()[face];
            int triB = model.getFaceIndices2()[face];
            int triC = model.getFaceIndices3()[face];
            int[] xVertices = model.getVerticesX();
            int[] zVertices = model.getVerticesZ();
            material = this.proceduralGenerator.getSeasonalMaterial(material);
            int packedMaterialData = this.packMaterialData(Material.getIndexFromDiffuseID(material.getDiffuseMapId()), false);
            if (objectProperties.getUvType() == UvType.GROUND_PLANE) {
                ModelPusher.twelveFloats[0] = packedMaterialData;
                ModelPusher.twelveFloats[1] = (float)(xVertices[triA] % 128) / 128.0f;
                ModelPusher.twelveFloats[2] = (float)(zVertices[triA] % 128) / 128.0f;
                ModelPusher.twelveFloats[3] = 0.0f;
                ModelPusher.twelveFloats[4] = packedMaterialData;
                ModelPusher.twelveFloats[5] = (float)(xVertices[triB] % 128) / 128.0f;
                ModelPusher.twelveFloats[6] = (float)(zVertices[triB] % 128) / 128.0f;
                ModelPusher.twelveFloats[7] = 0.0f;
                ModelPusher.twelveFloats[8] = packedMaterialData;
                ModelPusher.twelveFloats[9] = (float)(xVertices[triC] % 128) / 128.0f;
                ModelPusher.twelveFloats[10] = (float)(zVertices[triC] % 128) / 128.0f;
                ModelPusher.twelveFloats[11] = 0.0f;
                return twelveFloats;
            }
            ModelPusher.twelveFloats[0] = packedMaterialData;
            ModelPusher.twelveFloats[1] = 0.0f;
            ModelPusher.twelveFloats[2] = 0.0f;
            ModelPusher.twelveFloats[3] = 0.0f;
            ModelPusher.twelveFloats[4] = packedMaterialData;
            ModelPusher.twelveFloats[5] = 1.0f;
            ModelPusher.twelveFloats[6] = 0.0f;
            ModelPusher.twelveFloats[7] = 0.0f;
            ModelPusher.twelveFloats[8] = packedMaterialData;
            ModelPusher.twelveFloats[9] = 0.0f;
            ModelPusher.twelveFloats[10] = 1.0f;
            ModelPusher.twelveFloats[11] = 0.0f;
            return twelveFloats;
        }
        if (faceTextures != null) {
            return zeroFloats;
        }
        return null;
    }

    public int packMaterialData(int materialId, boolean isOverlay) {
        if (materialId == Material.getIndex(Material.INFERNAL_CAPE) && this.hdPlugin.configHdInfernalTexture) {
            materialId = Material.getIndex(Material.HD_INFERNAL_CAPE);
        }
        if (this.hdPlugin.configObjectTextures) {
            if (materialId == Material.getIndex(Material.BRICK)) {
                materialId = Material.getIndex(Material.HD_BRICK);
            } else if (materialId == Material.getIndex(Material.ROOF_SHINGLES_1)) {
                materialId = Material.getIndex(Material.HD_ROOF_SHINGLES_1);
            } else if (materialId == Material.getIndex(Material.MARBLE_DARK)) {
                materialId = Material.getIndex(Material.HD_MARBLE_DARK);
            } else if (materialId == Material.getIndex(Material.BRICK_BROWN)) {
                materialId = Material.getIndex(Material.HD_BRICK_BROWN);
            } else if (materialId == Material.getIndex(Material.LAVA)) {
                materialId = Material.getIndex(Material.HD_LAVA_3);
            } else if (materialId == Material.getIndex(Material.ROOF_SHINGLES_2)) {
                materialId = Material.getIndex(Material.HD_ROOF_SHINGLES_2);
            }
        }
        return materialId << 1 | (isOverlay ? 1 : 0);
    }

    private ModelData getCachedModelData(Renderable renderable, Model model, ObjectProperties objectProperties, ObjectType objectType, int tileX, int tileY, int tileZ, int faceCount, boolean noCache, int hash) {
        if (noCache) {
            tempModelData.setColors(this.getColorsForModel(renderable, model, objectProperties, objectType, tileX, tileY, tileZ, faceCount));
            return tempModelData;
        }
        ModelData modelData = this.modelCache.get(hash);
        if (modelData == null || modelData.getFaceCount() != model.getFaceCount()) {
            modelData = new ModelData().setColors(this.getColorsForModel(renderable, model, objectProperties, objectType, tileX, tileY, tileZ, faceCount)).setFaceCount(model.getFaceCount());
            this.modelCache.put(hash, modelData);
        }
        return modelData;
    }

    private int[] getColorsForModel(Renderable renderable, Model model, ObjectProperties objectProperties, ObjectType objectType, int tileX, int tileY, int tileZ, int faceCount) {
        for (int face = 0; face < faceCount; ++face) {
            System.arraycopy(this.getColorsForFace(renderable, model, objectProperties, objectType, tileX, tileY, tileZ, face), 0, modelColors, face * 4, 4);
        }
        return Arrays.copyOfRange(modelColors, 0, faceCount * 4);
    }

    private int[] removeBakedGroundShading(int face, int triA, int triB, int triC, byte[] faceTransparencies, short[] faceTextures, int[] yVertices) {
        if (faceTransparencies != null && (faceTextures == null || faceTextures[face] == -1) && (faceTransparencies[face] & 0xFF) > 100) {
            int aHeight = yVertices[triA];
            int bHeight = yVertices[triB];
            int cHeight = yVertices[triC];
            if (aHeight >= -8 && aHeight == bHeight && aHeight == cHeight) {
                ModelPusher.fourInts[0] = 0;
                ModelPusher.fourInts[1] = 0;
                ModelPusher.fourInts[2] = 0;
                ModelPusher.fourInts[3] = -16777216;
                return fourInts;
            }
        }
        return null;
    }

    private int[] getColorsForFace(Renderable renderable, Model model, ObjectProperties objectProperties, ObjectType objectType, int tileX, int tileY, int tileZ, int face) {
        int color1 = model.getFaceColors1()[face];
        int color2 = model.getFaceColors2()[face];
        int color3 = model.getFaceColors3()[face];
        short[] faceTextures = model.getFaceTextures();
        byte[] faceTransparencies = model.getFaceTransparencies();
        byte overrideAmount = model.getOverrideAmount();
        byte overrideHue = model.getOverrideHue();
        byte overrideSat = model.getOverrideSaturation();
        byte overrideLum = model.getOverrideLuminance();
        int triA = model.getFaceIndices1()[face];
        int triB = model.getFaceIndices2()[face];
        int triC = model.getFaceIndices3()[face];
        int[] yVertices = model.getVerticesY();
        int[] xVertexNormals = model.getVertexNormalsX();
        int[] yVertexNormals = model.getVertexNormalsY();
        int[] zVertexNormals = model.getVertexNormalsZ();
        Tile tile = this.client.getScene().getTiles()[tileZ][tileX][tileY];
        if (this.config.hideBakedEffects()) {
            int[] transparency;
            GraphicsObject graphicsObject;
            NPC npc = renderable instanceof NPC ? (NPC)renderable : null;
            Player player = renderable instanceof Player ? (Player)renderable : null;
            GraphicsObject graphicsObject2 = graphicsObject = renderable instanceof GraphicsObject ? (GraphicsObject)renderable : null;
            if ((npc != null && BakedModels.NPCS.contains(npc.getId()) || graphicsObject != null && BakedModels.OBJECTS.contains(graphicsObject.getId()) || player != null && player.getPlayerComposition().getEquipmentId(KitType.WEAPON) == 5614) && (transparency = this.removeBakedGroundShading(face, triA, triB, triC, faceTransparencies, faceTextures, yVertices)) != null) {
                return transparency;
            }
        }
        if (color3 == -2) {
            ModelPusher.fourInts[0] = 0;
            ModelPusher.fourInts[1] = 0;
            ModelPusher.fourInts[2] = 0;
            ModelPusher.fourInts[3] = -16777216;
            return fourInts;
        }
        if (color3 == -1) {
            color2 = color3 = color1;
        } else if ((faceTextures == null || faceTextures[face] == -1) && overrideAmount > 0) {
            color1 = ModelPusher.interpolateHSL(color1, overrideHue, overrideSat, overrideLum, overrideAmount);
            color2 = ModelPusher.interpolateHSL(color2, overrideHue, overrideSat, overrideLum, overrideAmount);
            color3 = ModelPusher.interpolateHSL(color3, overrideHue, overrideSat, overrideLum, overrideAmount);
        }
        int color1H = color1 >> 10 & 0x3F;
        int color1S = color1 >> 7 & 7;
        int color1L = color1 & 0x7F;
        int color2H = color2 >> 10 & 0x3F;
        int color2S = color2 >> 7 & 7;
        int color2L = color2 & 0x7F;
        int color3H = color3 >> 10 & 0x3F;
        int color3S = color3 >> 7 & 7;
        int color3L = color3 & 0x7F;
        int lightenA = (int)((float)Math.max(color1L - 3, 0) * 3.0f) + 10;
        float dotA = Math.max(HDUtils.dotNormal3Lights(new float[]{xVertexNormals[triA], yVertexNormals[triA], zVertexNormals[triA]}), 0.0f);
        color1L = (int)HDUtils.lerp(color1L, lightenA, dotA);
        int lightenB = (int)((float)Math.max(color2L - 3, 0) * 3.0f) + 10;
        float dotB = Math.max(HDUtils.dotNormal3Lights(new float[]{xVertexNormals[triB], yVertexNormals[triB], zVertexNormals[triB]}), 0.0f);
        color2L = (int)HDUtils.lerp(color2L, lightenB, dotB);
        int lightenC = (int)((float)Math.max(color3L - 3, 0) * 3.0f) + 10;
        float dotC = Math.max(HDUtils.dotNormal3Lights(new float[]{xVertexNormals[triC], yVertexNormals[triC], zVertexNormals[triC]}), 0.0f);
        color3L = (int)HDUtils.lerp(color3L, lightenC, dotC);
        int maxBrightness = 55;
        if (faceTextures != null && faceTextures[face] != -1) {
            maxBrightness = 90;
            color3H = 0;
            color2H = 0;
            color1H = 0;
            color3S = 0;
            color2S = 0;
            color1S = 0;
            color3L = 127;
            color2L = 127;
            color1L = 127;
        }
        if (objectProperties != null && objectProperties.isInheritTileColor() && tile != null && (tile.getSceneTilePaint() != null || tile.getSceneTileModel() != null)) {
            int[] tileColorHSL;
            if (tile.getSceneTilePaint() != null && tile.getSceneTilePaint().getTexture() == -1) {
                tileColorHSL = HDUtils.colorIntToHSL(tile.getSceneTilePaint().getSwColor());
                tileColorHSL[1] = (tileColorHSL[1] + HDUtils.colorIntToHSL(tile.getSceneTilePaint().getSeColor())[1] + HDUtils.colorIntToHSL(tile.getSceneTilePaint().getNwColor())[1] + HDUtils.colorIntToHSL(tile.getSceneTilePaint().getNeColor())[1]) / 4;
                tileColorHSL[2] = (tileColorHSL[2] + HDUtils.colorIntToHSL(tile.getSceneTilePaint().getSeColor())[2] + HDUtils.colorIntToHSL(tile.getSceneTilePaint().getNwColor())[2] + HDUtils.colorIntToHSL(tile.getSceneTilePaint().getNeColor())[2]) / 4;
                byte overlayId = this.client.getScene().getOverlayIds()[tileZ][tileX][tileY];
                byte underlayId = this.client.getScene().getUnderlayIds()[tileZ][tileX][tileY];
                if (overlayId != 0) {
                    Overlay overlay = Overlay.getOverlay(overlayId, tile, this.client);
                    overlay = this.proceduralGenerator.getSeasonalOverlay(overlay);
                    tileColorHSL = this.proceduralGenerator.recolorOverlay(overlay, tileColorHSL);
                } else {
                    Underlay underlay = Underlay.getUnderlay(underlayId, tile, this.client);
                    underlay = this.proceduralGenerator.getSeasonalUnderlay(underlay);
                    tileColorHSL = this.proceduralGenerator.recolorUnderlay(underlay, tileColorHSL);
                }
                color2H = color3H = tileColorHSL[0];
                color1H = color3H;
                color2S = color3S = tileColorHSL[1];
                color1S = color3S;
                color2L = color3L = tileColorHSL[2];
                color1L = color3L;
            } else if (tile.getSceneTileModel() != null && tile.getSceneTileModel().getTriangleTextureId() == null) {
                int faceColorIndex = -1;
                for (int i = 0; i < tile.getSceneTileModel().getTriangleColorA().length; ++i) {
                    if (this.proceduralGenerator.isOverlayFace(tile, i)) continue;
                    faceColorIndex = i;
                    break;
                }
                if (faceColorIndex != -1) {
                    tileColorHSL = HDUtils.colorIntToHSL(tile.getSceneTileModel().getTriangleColorA()[faceColorIndex]);
                    byte underlayId = this.client.getScene().getUnderlayIds()[tileZ][tileX][tileY];
                    Underlay underlay = Underlay.getUnderlay(underlayId, tile, this.client);
                    underlay = this.proceduralGenerator.getSeasonalUnderlay(underlay);
                    tileColorHSL = this.proceduralGenerator.recolorUnderlay(underlay, tileColorHSL);
                    color2H = color3H = tileColorHSL[0];
                    color1H = color3H;
                    color2S = color3S = tileColorHSL[1];
                    color1S = color3S;
                    color2L = color3L = tileColorHSL[2];
                    color1L = color3L;
                }
            }
        }
        int packedAlphaPriority = this.getPackedAlphaPriority(model, face);
        if (this.hdPlugin.configTzhaarHD && objectProperties != null && objectProperties.getTzHaarRecolorType() != TzHaarRecolorType.NONE) {
            int[][] tzHaarRecolored = this.proceduralGenerator.recolorTzHaar(objectProperties, yVertices[triA], yVertices[triB], yVertices[triC], packedAlphaPriority, objectType, color1H, color1S, color1L, color2H, color2S, color2L, color3H, color3S, color3L);
            color1H = tzHaarRecolored[0][0];
            color1S = tzHaarRecolored[0][1];
            color1L = tzHaarRecolored[0][2];
            color2H = tzHaarRecolored[1][0];
            color2S = tzHaarRecolored[1][1];
            color2L = tzHaarRecolored[1][2];
            color3H = tzHaarRecolored[2][0];
            color3S = tzHaarRecolored[2][1];
            color3L = tzHaarRecolored[2][2];
            packedAlphaPriority = tzHaarRecolored[3][0];
        }
        color1L = Ints.constrainToRange(color1L, 0, maxBrightness);
        color2L = Ints.constrainToRange(color2L, 0, maxBrightness);
        color3L = Ints.constrainToRange(color3L, 0, maxBrightness);
        color1 = (color1H << 3 | color1S) << 7 | color1L;
        color2 = (color2H << 3 | color2S) << 7 | color2L;
        color3 = (color3H << 3 | color3S) << 7 | color3L;
        ModelPusher.fourInts[0] = color1;
        ModelPusher.fourInts[1] = color2;
        ModelPusher.fourInts[2] = color3;
        ModelPusher.fourInts[3] = packedAlphaPriority;
        return fourInts;
    }

    private static int interpolateHSL(int hsl, byte hue2, byte sat2, byte lum2, byte lerp) {
        int hue = hsl >> 10 & 0x3F;
        int sat = hsl >> 7 & 7;
        int lum = hsl & 0x7F;
        int var9 = lerp & 0xFF;
        if (hue2 != -1) {
            hue += var9 * (hue2 - hue) >> 7;
        }
        if (sat2 != -1) {
            sat += var9 * (sat2 - sat) >> 7;
        }
        if (lum2 != -1) {
            lum += var9 * (lum2 - lum) >> 7;
        }
        return (hue << 10 | sat << 7 | lum) & 0xFFFF;
    }

    private int getPackedAlphaPriority(Model model, int face) {
        short[] faceTextures = model.getFaceTextures();
        byte[] faceTransparencies = model.getFaceTransparencies();
        byte[] facePriorities = model.getFaceRenderPriorities();
        int alpha = 0;
        if (faceTransparencies != null && (faceTextures == null || faceTextures[face] == -1)) {
            alpha = (faceTransparencies[face] & 0xFF) << 24;
        }
        int priority = 0;
        if (facePriorities != null) {
            priority = (facePriorities[face] & 0xFF) << 16;
        }
        return alpha | priority;
    }
}

