/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd;

import com.google.common.primitives.Ints;
import com.google.inject.Provides;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.SwingUtilities;
import net.runelite.api.BufferProvider;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.GroundObject;
import net.runelite.api.Model;
import net.runelite.api.Perspective;
import net.runelite.api.Renderable;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Texture;
import net.runelite.api.TextureProvider;
import net.runelite.api.WallObject;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.DecorativeObjectChanged;
import net.runelite.api.events.DecorativeObjectDespawned;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.GameObjectChanged;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GroundObjectChanged;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.api.events.WallObjectChanged;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.api.hooks.DrawCallbacks;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginInstantiationException;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.entityhider.EntityHiderPlugin;
import net.runelite.client.plugins.hd.HdPluginConfig;
import net.runelite.client.plugins.hd.config.AntiAliasingMode;
import net.runelite.client.plugins.hd.config.DefaultSkyColor;
import net.runelite.client.plugins.hd.config.FogDepthMode;
import net.runelite.client.plugins.hd.config.UIScalingMode;
import net.runelite.client.plugins.hd.data.materials.Material;
import net.runelite.client.plugins.hd.model.ModelHasher;
import net.runelite.client.plugins.hd.model.ModelPusher;
import net.runelite.client.plugins.hd.model.TempModelInfo;
import net.runelite.client.plugins.hd.model.objects.ObjectProperties;
import net.runelite.client.plugins.hd.model.objects.ObjectType;
import net.runelite.client.plugins.hd.opengl.compute.ComputeMode;
import net.runelite.client.plugins.hd.opengl.compute.OpenCLManager;
import net.runelite.client.plugins.hd.opengl.shader.Shader;
import net.runelite.client.plugins.hd.opengl.shader.ShaderException;
import net.runelite.client.plugins.hd.opengl.shader.Template;
import net.runelite.client.plugins.hd.scene.EnvironmentManager;
import net.runelite.client.plugins.hd.scene.ProceduralGenerator;
import net.runelite.client.plugins.hd.scene.SceneUploader;
import net.runelite.client.plugins.hd.scene.TextureManager;
import net.runelite.client.plugins.hd.scene.lighting.LightManager;
import net.runelite.client.plugins.hd.scene.lighting.SceneLight;
import net.runelite.client.plugins.hd.utils.DeveloperTools;
import net.runelite.client.plugins.hd.utils.HDUtils;
import net.runelite.client.plugins.hd.utils.Mat4;
import net.runelite.client.plugins.hd.utils.buffer.GLBuffer;
import net.runelite.client.plugins.hd.utils.buffer.GpuFloatBuffer;
import net.runelite.client.plugins.hd.utils.buffer.GpuIntBuffer;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.util.OSType;
import net.runelite.rlawt.AWTContext;
import org.jocl.CL;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLUtil;
import org.lwjgl.system.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="117 HD (beta)", enabledByDefault=false, hidden=true, description="GPU renderer with a suite of graphical enhancements", tags={"hd", "high", "detail", "graphics", "shaders", "textures", "gpu", "shadows", "lights"}, conflicts={"GPU"})
@PluginDependency(value=EntityHiderPlugin.class)
public class HdPlugin
extends Plugin
implements DrawCallbacks {
    private static final Logger log = LoggerFactory.getLogger(HdPlugin.class);
    public static final int MAX_TRIANGLE = 8192;
    public static final int SMALL_TRIANGLE_COUNT = 512;
    private static final int FLAG_SCENE_BUFFER = Integer.MIN_VALUE;
    private static final int DEFAULT_DISTANCE = 25;
    static final int MAX_DISTANCE = 90;
    static final int MAX_FOG_DEPTH = 100;
    private static final int MAX_MATERIALS = Material.values().length;
    private static final int MAX_LIGHTS = 100;
    private static final int MATERIAL_PROPERTIES_COUNT = 12;
    private static final int LIGHT_PROPERTIES_COUNT = 8;
    private static final int SCALAR_BYTES = 4;
    private static final int[] eightIntWrite = new int[8];
    @Inject
    private Client client;
    @Inject
    private OpenCLManager openCLManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private HdPluginConfig config;
    @Inject
    private TextureManager textureManager;
    @Inject
    private LightManager lightManager;
    @Inject
    private EnvironmentManager environmentManager;
    @Inject
    private SceneUploader sceneUploader;
    @Inject
    private DrawManager drawManager;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private ProceduralGenerator proceduralGenerator;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ModelPusher modelPusher;
    @Inject
    private ModelHasher modelHasher;
    @Inject
    @Named(value="developerMode")
    private boolean developerMode;
    @Inject
    private DeveloperTools developerTools;
    private ComputeMode computeMode = ComputeMode.OPENGL;
    private Canvas canvas;
    private AWTContext awtContext;
    private Callback debugCallback;
    static final String LINUX_VERSION_HEADER = "#version 420\n#extension GL_ARB_compute_shader : require\n#extension GL_ARB_shader_storage_buffer_object : require\n#extension GL_ARB_explicit_attrib_location : require\n";
    static final String WINDOWS_VERSION_HEADER = "#version 430\n";
    static final Shader PROGRAM = new Shader().add(35633, "vert.glsl").add(36313, "geom.glsl").add(35632, "frag.glsl");
    static final Shader SHADOW_PROGRAM = new Shader().add(35633, "shadow_vert.glsl").add(35632, "shadow_frag.glsl");
    static final Shader COMPUTE_PROGRAM = new Shader().add(37305, "comp.glsl");
    static final Shader SMALL_COMPUTE_PROGRAM = new Shader().add(37305, "comp_small.glsl");
    static final Shader UNORDERED_COMPUTE_PROGRAM = new Shader().add(37305, "comp_unordered.glsl");
    static final Shader UI_PROGRAM = new Shader().add(35633, "vertui.glsl").add(35632, "fragui.glsl");
    private int glProgram = -1;
    private int glComputeProgram = -1;
    private int glSmallComputeProgram = -1;
    private int glUnorderedComputeProgram = -1;
    private int glUiProgram = -1;
    private int glShadowProgram = -1;
    private int vaoHandle = -1;
    private int interfaceTexture = -1;
    private int interfacePbo = -1;
    private int vaoUiHandle = -1;
    private int vboUiHandle = -1;
    private int fboSceneHandle = -1;
    private int rboSceneHandle = -1;
    private int fboShadowMap = -1;
    private int texShadowMap = -1;
    private final GLBuffer sceneVertexBuffer = new GLBuffer();
    private final GLBuffer sceneUvBuffer = new GLBuffer();
    private final GLBuffer sceneNormalBuffer = new GLBuffer();
    private final GLBuffer tmpVertexBuffer = new GLBuffer();
    private final GLBuffer tmpUvBuffer = new GLBuffer();
    private final GLBuffer tmpNormalBuffer = new GLBuffer();
    private final GLBuffer tmpModelBufferLarge = new GLBuffer();
    private final GLBuffer tmpModelBufferSmall = new GLBuffer();
    private final GLBuffer tmpModelBufferUnordered = new GLBuffer();
    private final GLBuffer tmpOutBuffer = new GLBuffer();
    private final GLBuffer tmpOutUvBuffer = new GLBuffer();
    private final GLBuffer tmpOutNormalBuffer = new GLBuffer();
    private int textureArrayId;
    private int textureHDArrayId;
    private final GLBuffer uniformBuffer = new GLBuffer();
    private float[] textureOffsets = new float[256];
    private final GLBuffer materialsUniformBuffer = new GLBuffer();
    private final GLBuffer lightsUniformBuffer = new GLBuffer();
    private ByteBuffer lightsUniformBuf;
    private GpuIntBuffer vertexBuffer;
    private GpuFloatBuffer uvBuffer;
    private GpuFloatBuffer normalBuffer;
    private GpuIntBuffer modelBufferUnordered;
    private GpuIntBuffer modelBufferSmall;
    private GpuIntBuffer modelBuffer;
    private int unorderedModels;
    private int smallModels;
    private int largeModels;
    private int targetBufferOffset;
    private int tempOffset;
    private int tempUvOffset;
    private int lastCanvasWidth;
    private int lastCanvasHeight;
    private int lastStretchedCanvasWidth;
    private int lastStretchedCanvasHeight;
    private AntiAliasingMode lastAntiAliasingMode;
    private int lastAnisotropicFilteringLevel = -1;
    private int yaw;
    private int pitch;
    private int viewportOffsetX;
    private int viewportOffsetY;
    private int uniColorBlindMode;
    private int uniUiColorBlindMode;
    private int uniUseFog;
    private int uniFogColor;
    private int uniFogDepth;
    private int uniDrawDistance;
    private int uniWaterColorLight;
    private int uniWaterColorMid;
    private int uniWaterColorDark;
    private int uniAmbientStrength;
    private int uniAmbientColor;
    private int uniLightStrength;
    private int uniLightColor;
    private int uniUnderglowStrength;
    private int uniUnderglowColor;
    private int uniGroundFogStart;
    private int uniGroundFogEnd;
    private int uniGroundFogOpacity;
    private int uniLightningBrightness;
    private int uniSaturation;
    private int uniContrast;
    private int uniLightX;
    private int uniLightY;
    private int uniLightZ;
    private int uniShadowMaxBias;
    private int uniShadowsEnabled;
    private int uniUnderwaterEnvironment;
    private int uniUnderwaterCaustics;
    private int uniUnderwaterCausticsColor;
    private int uniUnderwaterCausticsStrength;
    private int uniShadowTexturesHD;
    private int uniShadowTextureOffsets;
    private int uniShadowLightProjectionMatrix;
    private int uniPointLightsCount;
    private int uniProjectionMatrix;
    private int uniLightProjectionMatrix;
    private int uniShadowMap;
    private int uniTex;
    private int uniTexSamplingMode;
    private int uniTexSourceDimensions;
    private int uniTexTargetDimensions;
    private int uniUiAlphaOverlay;
    private int uniTextures;
    private int uniTexturesHD;
    private int uniTextureOffsets;
    private int uniAnimationCurrent;
    private int uniBlockSmall;
    private int uniBlockLarge;
    private int uniBlockMain;
    private int uniBlockMaterials;
    private int uniShadowBlockMaterials;
    private int uniBlockPointLights;
    private long lastFrameTime = System.currentTimeMillis();
    private float animationCurrent = 0.0f;
    private long nextSceneReload = 0L;
    private boolean isInHouse = false;
    private int previousPlane;
    public boolean configGroundTextures = false;
    public boolean configGroundBlending = false;
    public boolean configObjectTextures = true;
    public boolean configTzhaarHD = true;
    public boolean configProjectileLights = true;
    public boolean configNpcLights = true;
    public boolean configShadowsEnabled = false;
    public boolean configExpandShadowDraw = false;
    public boolean configHdInfernalTexture = true;
    public boolean configWinterTheme = true;
    public int[] camTarget = new int[3];
    private boolean hasLoggedIn;
    private boolean lwjglInitted = false;
    private boolean isInGauntlet = false;
    private final Map<Integer, TempModelInfo> tempModelInfoMap = new HashMap<Integer, TempModelInfo>();
    private boolean clear = false;
    private boolean skyboxColorChanged = false;

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (!this.isInGauntlet) {
            return;
        }
        if (event.getMessage().equals("You light the nodes in the corridor to help guide the way.")) {
            this.reloadScene();
        }
    }

    @Override
    protected void startUp() {
    }

    @Override
    protected void shutDown() {
        this.clear = true;
        this.developerTools.deactivate();
        this.lightManager.shutDown();
        this.clientThread.invoke(() -> {
            this.client.setGpu(false);
            this.client.setDrawCallbacks(null);
            this.client.setUnlockedFps(false);
            if (this.lwjglInitted) {
                this.openCLManager.cleanup();
                if (this.textureArrayId != -1) {
                    this.textureManager.freeTextureArray(this.textureArrayId);
                    this.textureArrayId = -1;
                }
                if (this.textureHDArrayId != -1) {
                    this.textureManager.freeTextureArray(this.textureHDArrayId);
                    this.textureHDArrayId = -1;
                }
                this.destroyGlBuffer(this.uniformBuffer);
                this.destroyGlBuffer(this.materialsUniformBuffer);
                this.destroyGlBuffer(this.lightsUniformBuffer);
                this.shutdownBuffers();
                this.shutdownInterfaceTexture();
                this.shutdownPrograms();
                this.shutdownVao();
                this.shutdownAAFbo();
                this.shutdownShadowMapFbo();
            }
            if (this.awtContext != null) {
                this.awtContext.destroy();
                this.awtContext = null;
            }
            if (this.debugCallback != null) {
                this.debugCallback.free();
                this.debugCallback = null;
            }
            this.vertexBuffer = null;
            this.uvBuffer = null;
            this.normalBuffer = null;
            this.modelBufferSmall = null;
            this.modelBuffer = null;
            this.modelBufferUnordered = null;
            this.lastAnisotropicFilteringLevel = -1;
            this.client.resizeCanvas();
        });
    }

    private void stopPlugin() {
        SwingUtilities.invokeLater(() -> {
            try {
                this.pluginManager.setPluginEnabled(this, false);
                this.pluginManager.stopPlugin(this);
            }
            catch (PluginInstantiationException ex) {
                log.error("error stopping plugin", ex);
            }
        });
        this.shutDown();
    }

    @Provides
    HdPluginConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(HdPluginConfig.class);
    }

    private String generateFetchMaterialCases(int from, int to) {
        int length = to - from;
        if (length == 1) {
            return "material[" + from + "]";
        }
        int middle = from + length / 2;
        return "i < " + middle + " ? " + this.generateFetchMaterialCases(from, middle) + " : " + this.generateFetchMaterialCases(middle, to);
    }

    private void initPrograms() throws ShaderException {
        String versionHeader = OSType.getOSType() == OSType.Linux ? LINUX_VERSION_HEADER : WINDOWS_VERSION_HEADER;
        Template template = new Template();
        template.add(key -> {
            switch (key) {
                case "version_header": {
                    return versionHeader;
                }
                case "MAX_MATERIALS": {
                    return String.format("#define %s %d\n", key, MAX_MATERIALS);
                }
                case "CONST_MACOS_INTEL_WORKAROUND": {
                    boolean isAppleM1 = OSType.getOSType() == OSType.MacOS && System.getProperty("os.arch").equals("aarch64");
                    return String.format("#define %s %d\n", key, this.config.macosIntelWorkaround() && !isAppleM1 ? 1 : 0);
                }
                case "MACOS_INTEL_WORKAROUND_MATERIAL_CASES": {
                    return "return " + this.generateFetchMaterialCases(0, MAX_MATERIALS) + ";";
                }
            }
            return null;
        });
        if (this.developerMode) {
            template.add(this.developerTools::shaderResolver);
        }
        template.addInclude(HdPlugin.class);
        this.glProgram = PROGRAM.compile(template);
        this.glUiProgram = UI_PROGRAM.compile(template);
        this.glShadowProgram = SHADOW_PROGRAM.compile(template);
        if (this.computeMode == ComputeMode.OPENCL) {
            this.openCLManager.init(this.awtContext);
        } else {
            this.glComputeProgram = COMPUTE_PROGRAM.compile(template);
            this.glSmallComputeProgram = SMALL_COMPUTE_PROGRAM.compile(template);
            this.glUnorderedComputeProgram = UNORDERED_COMPUTE_PROGRAM.compile(template);
        }
        this.initUniforms();
        GL43C.glUseProgram(this.glProgram);
        GL43C.glUniform1i(this.uniTextures, 1);
        GL43C.glUniform1i(this.uniTexturesHD, 2);
        GL43C.glUniform1i(this.uniShadowMap, 3);
        GL43C.glUseProgram(0);
        GL43C.glValidateProgram(this.glProgram);
        if (GL43C.glGetProgrami(this.glProgram, 35715) == 0) {
            String err = GL43C.glGetProgramInfoLog(this.glProgram);
            throw new ShaderException(err);
        }
    }

    private void initUniforms() {
        this.uniProjectionMatrix = GL43C.glGetUniformLocation(this.glProgram, "projectionMatrix");
        this.uniLightProjectionMatrix = GL43C.glGetUniformLocation(this.glProgram, "lightProjectionMatrix");
        this.uniShadowMap = GL43C.glGetUniformLocation(this.glProgram, "shadowMap");
        this.uniSaturation = GL43C.glGetUniformLocation(this.glProgram, "saturation");
        this.uniContrast = GL43C.glGetUniformLocation(this.glProgram, "contrast");
        this.uniUseFog = GL43C.glGetUniformLocation(this.glProgram, "useFog");
        this.uniFogColor = GL43C.glGetUniformLocation(this.glProgram, "fogColor");
        this.uniFogDepth = GL43C.glGetUniformLocation(this.glProgram, "fogDepth");
        this.uniWaterColorLight = GL43C.glGetUniformLocation(this.glProgram, "waterColorLight");
        this.uniWaterColorMid = GL43C.glGetUniformLocation(this.glProgram, "waterColorMid");
        this.uniWaterColorDark = GL43C.glGetUniformLocation(this.glProgram, "waterColorDark");
        this.uniDrawDistance = GL43C.glGetUniformLocation(this.glProgram, "drawDistance");
        this.uniAmbientStrength = GL43C.glGetUniformLocation(this.glProgram, "ambientStrength");
        this.uniAmbientColor = GL43C.glGetUniformLocation(this.glProgram, "ambientColor");
        this.uniLightStrength = GL43C.glGetUniformLocation(this.glProgram, "lightStrength");
        this.uniLightColor = GL43C.glGetUniformLocation(this.glProgram, "lightColor");
        this.uniUnderglowStrength = GL43C.glGetUniformLocation(this.glProgram, "underglowStrength");
        this.uniUnderglowColor = GL43C.glGetUniformLocation(this.glProgram, "underglowColor");
        this.uniGroundFogStart = GL43C.glGetUniformLocation(this.glProgram, "groundFogStart");
        this.uniGroundFogEnd = GL43C.glGetUniformLocation(this.glProgram, "groundFogEnd");
        this.uniGroundFogOpacity = GL43C.glGetUniformLocation(this.glProgram, "groundFogOpacity");
        this.uniLightningBrightness = GL43C.glGetUniformLocation(this.glProgram, "lightningBrightness");
        this.uniPointLightsCount = GL43C.glGetUniformLocation(this.glProgram, "pointLightsCount");
        this.uniColorBlindMode = GL43C.glGetUniformLocation(this.glProgram, "colorBlindMode");
        this.uniLightX = GL43C.glGetUniformLocation(this.glProgram, "lightX");
        this.uniLightY = GL43C.glGetUniformLocation(this.glProgram, "lightY");
        this.uniLightZ = GL43C.glGetUniformLocation(this.glProgram, "lightZ");
        this.uniShadowMaxBias = GL43C.glGetUniformLocation(this.glProgram, "shadowMaxBias");
        this.uniShadowsEnabled = GL43C.glGetUniformLocation(this.glProgram, "shadowsEnabled");
        this.uniUnderwaterEnvironment = GL43C.glGetUniformLocation(this.glProgram, "underwaterEnvironment");
        this.uniUnderwaterCaustics = GL43C.glGetUniformLocation(this.glProgram, "underwaterCaustics");
        this.uniUnderwaterCausticsColor = GL43C.glGetUniformLocation(this.glProgram, "underwaterCausticsColor");
        this.uniUnderwaterCausticsStrength = GL43C.glGetUniformLocation(this.glProgram, "underwaterCausticsStrength");
        this.uniTex = GL43C.glGetUniformLocation(this.glUiProgram, "tex");
        this.uniTexSamplingMode = GL43C.glGetUniformLocation(this.glUiProgram, "samplingMode");
        this.uniTexTargetDimensions = GL43C.glGetUniformLocation(this.glUiProgram, "targetDimensions");
        this.uniTexSourceDimensions = GL43C.glGetUniformLocation(this.glUiProgram, "sourceDimensions");
        this.uniUiColorBlindMode = GL43C.glGetUniformLocation(this.glUiProgram, "colorBlindMode");
        this.uniUiAlphaOverlay = GL43C.glGetUniformLocation(this.glUiProgram, "alphaOverlay");
        this.uniTextures = GL43C.glGetUniformLocation(this.glProgram, "textures");
        this.uniTexturesHD = GL43C.glGetUniformLocation(this.glProgram, "texturesHD");
        this.uniTextureOffsets = GL43C.glGetUniformLocation(this.glProgram, "textureOffsets");
        this.uniAnimationCurrent = GL43C.glGetUniformLocation(this.glProgram, "animationCurrent");
        if (this.computeMode == ComputeMode.OPENGL) {
            this.uniBlockSmall = GL43C.glGetUniformBlockIndex(this.glSmallComputeProgram, "uniforms");
            this.uniBlockLarge = GL43C.glGetUniformBlockIndex(this.glComputeProgram, "uniforms");
            this.uniBlockMain = GL43C.glGetUniformBlockIndex(this.glProgram, "uniforms");
        }
        this.uniBlockMaterials = GL43C.glGetUniformBlockIndex(this.glProgram, "materials");
        this.uniBlockPointLights = GL43C.glGetUniformBlockIndex(this.glProgram, "pointLights");
        this.uniShadowBlockMaterials = GL43C.glGetUniformBlockIndex(this.glShadowProgram, "materials");
        this.uniShadowLightProjectionMatrix = GL43C.glGetUniformLocation(this.glShadowProgram, "lightProjectionMatrix");
        this.uniShadowTexturesHD = GL43C.glGetUniformLocation(this.glShadowProgram, "texturesHD");
        this.uniShadowTextureOffsets = GL43C.glGetUniformLocation(this.glShadowProgram, "textureOffsets");
    }

    private void shutdownPrograms() {
        if (this.glProgram != -1) {
            GL43C.glDeleteProgram(this.glProgram);
            this.glProgram = -1;
        }
        if (this.glComputeProgram != -1) {
            GL43C.glDeleteProgram(this.glComputeProgram);
            this.glComputeProgram = -1;
        }
        if (this.glSmallComputeProgram != -1) {
            GL43C.glDeleteProgram(this.glSmallComputeProgram);
            this.glSmallComputeProgram = -1;
        }
        if (this.glUnorderedComputeProgram != -1) {
            GL43C.glDeleteProgram(this.glUnorderedComputeProgram);
            this.glUnorderedComputeProgram = -1;
        }
        if (this.glUiProgram != -1) {
            GL43C.glDeleteProgram(this.glUiProgram);
            this.glUiProgram = -1;
        }
        if (this.glShadowProgram != -1) {
            GL43C.glDeleteProgram(this.glShadowProgram);
            this.glShadowProgram = -1;
        }
    }

    public void recompilePrograms() {
        this.clientThread.invoke(() -> {
            try {
                this.shutdownPrograms();
                this.shutdownVao();
                this.initVao();
                this.initPrograms();
            }
            catch (ShaderException ex) {
                log.error("Failed to recompile shader program", ex);
                this.stopPlugin();
            }
        });
    }

    private void initVao() {
        this.vaoHandle = GL43C.glGenVertexArrays();
        this.vaoUiHandle = GL43C.glGenVertexArrays();
        this.vboUiHandle = GL43C.glGenBuffers();
        GL43C.glBindVertexArray(this.vaoUiHandle);
        FloatBuffer vboUiBuf = GpuFloatBuffer.allocateDirect(20);
        vboUiBuf.put(new float[]{1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f});
        vboUiBuf.rewind();
        GL43C.glBindBuffer(34962, this.vboUiHandle);
        GL43C.glBufferData(34962, vboUiBuf, 35044);
        GL43C.glVertexAttribPointer(0, 3, 5126, false, 20, 0L);
        GL43C.glEnableVertexAttribArray(0);
        GL43C.glVertexAttribPointer(1, 2, 5126, false, 20, 12L);
        GL43C.glEnableVertexAttribArray(1);
        GL43C.glBindBuffer(34962, 0);
    }

    private void shutdownVao() {
        if (this.vaoHandle != -1) {
            GL43C.glDeleteVertexArrays(this.vaoHandle);
            this.vaoHandle = -1;
        }
        if (this.vboUiHandle != -1) {
            GL43C.glDeleteBuffers(this.vboUiHandle);
            this.vboUiHandle = -1;
        }
        if (this.vaoUiHandle != -1) {
            GL43C.glDeleteVertexArrays(this.vaoUiHandle);
            this.vaoUiHandle = -1;
        }
    }

    private void initBuffers() {
        this.initGlBuffer(this.sceneVertexBuffer);
        this.initGlBuffer(this.sceneUvBuffer);
        this.initGlBuffer(this.sceneNormalBuffer);
        this.initGlBuffer(this.tmpVertexBuffer);
        this.initGlBuffer(this.tmpUvBuffer);
        this.initGlBuffer(this.tmpNormalBuffer);
        this.initGlBuffer(this.tmpModelBufferLarge);
        this.initGlBuffer(this.tmpModelBufferSmall);
        this.initGlBuffer(this.tmpModelBufferUnordered);
        this.initGlBuffer(this.tmpOutBuffer);
        this.initGlBuffer(this.tmpOutUvBuffer);
        this.initGlBuffer(this.tmpOutNormalBuffer);
    }

    private void initGlBuffer(GLBuffer glBuffer) {
        glBuffer.glBufferId = GL43C.glGenBuffers();
    }

    private void shutdownBuffers() {
        this.destroyGlBuffer(this.sceneVertexBuffer);
        this.destroyGlBuffer(this.sceneUvBuffer);
        this.destroyGlBuffer(this.sceneNormalBuffer);
        this.destroyGlBuffer(this.tmpVertexBuffer);
        this.destroyGlBuffer(this.tmpUvBuffer);
        this.destroyGlBuffer(this.tmpNormalBuffer);
        this.destroyGlBuffer(this.tmpModelBufferLarge);
        this.destroyGlBuffer(this.tmpModelBufferSmall);
        this.destroyGlBuffer(this.tmpModelBufferUnordered);
        this.destroyGlBuffer(this.tmpOutBuffer);
        this.destroyGlBuffer(this.tmpOutUvBuffer);
        this.destroyGlBuffer(this.tmpOutNormalBuffer);
    }

    private void destroyGlBuffer(GLBuffer glBuffer) {
        if (glBuffer.glBufferId != -1) {
            GL43C.glDeleteBuffers(glBuffer.glBufferId);
            glBuffer.glBufferId = -1;
        }
        glBuffer.size = -1;
        if (glBuffer.cl_mem != null) {
            CL.clReleaseMemObject(glBuffer.cl_mem);
            glBuffer.cl_mem = null;
        }
    }

    private void initInterfaceTexture() {
        this.interfacePbo = GL43C.glGenBuffers();
        this.interfaceTexture = GL43C.glGenTextures();
        GL43C.glBindTexture(3553, this.interfaceTexture);
        GL43C.glTexParameteri(3553, 10242, 33071);
        GL43C.glTexParameteri(3553, 10243, 33071);
        GL43C.glTexParameteri(3553, 10241, 9729);
        GL43C.glTexParameteri(3553, 10240, 9729);
        GL43C.glBindTexture(3553, 0);
    }

    private void shutdownInterfaceTexture() {
        if (this.interfacePbo != -1) {
            GL43C.glDeleteBuffers(this.interfacePbo);
            this.interfacePbo = -1;
        }
        if (this.interfaceTexture != -1) {
            GL43C.glDeleteTextures(this.interfaceTexture);
            this.interfaceTexture = -1;
        }
    }

    private void initUniformBuffer() {
        this.initGlBuffer(this.uniformBuffer);
        IntBuffer uniformBuf = GpuIntBuffer.allocateDirect(8200);
        uniformBuf.put(new int[8]);
        int[] pad = new int[2];
        for (int i = 0; i < 2048; ++i) {
            uniformBuf.put(Perspective.SINE[i]);
            uniformBuf.put(Perspective.COSINE[i]);
            uniformBuf.put(pad);
        }
        uniformBuf.flip();
        this.updateBuffer(this.uniformBuffer, 35345, uniformBuf, 35048, 4L);
        GL43C.glBindBuffer(35345, 0);
    }

    private void initMaterialsUniformBuffer() {
        if (Material.values().length > MAX_MATERIALS) {
            log.error("Number of materials exceeds value of MAX_MATERIALS");
        }
        this.initGlBuffer(this.materialsUniformBuffer);
        ByteBuffer materialUniformBuf = ByteBuffer.allocateDirect(MAX_MATERIALS * 12 * 4).order(ByteOrder.nativeOrder());
        for (int i = 0; i < Math.min(MAX_MATERIALS, Material.values().length); ++i) {
            Material material = Material.values()[i];
            materialUniformBuf.putInt(material.getDiffuseMapId());
            materialUniformBuf.putFloat(material.getSpecularStrength());
            materialUniformBuf.putFloat(material.getSpecularGloss());
            materialUniformBuf.putFloat(material.getEmissiveStrength());
            materialUniformBuf.putInt(material.getDisplacementMapId());
            materialUniformBuf.putFloat(material.getDisplacementStrength());
            materialUniformBuf.putFloat(material.getDisplacementDurationX());
            materialUniformBuf.putFloat(material.getDisplacementDurationY());
            materialUniformBuf.putFloat(material.getScrollDurationX());
            materialUniformBuf.putFloat(material.getScrollDurationY());
            materialUniformBuf.putFloat(material.getTextureScaleX());
            materialUniformBuf.putFloat(material.getTextureScaleY());
            materialUniformBuf.put(new byte[((int)Math.ceil(3.0) * 4 - 12) * 4]);
        }
        materialUniformBuf.flip();
        this.updateBuffer(this.materialsUniformBuffer, 35345, materialUniformBuf, 35044, 4L);
        GL43C.glBindBuffer(35345, 0);
    }

    private void initLightsUniformBuffer() {
        if (this.config.maxDynamicLights().getValue() > 100) {
            log.warn("Number of max dynamic lights exceeds value of MAX_LIGHTS");
        }
        this.initGlBuffer(this.lightsUniformBuffer);
        this.lightsUniformBuf = ByteBuffer.allocateDirect(3200).order(ByteOrder.nativeOrder());
        this.updateBuffer(this.lightsUniformBuffer, 35345, this.lightsUniformBuf, 35048, 4L);
        GL43C.glBindBuffer(35345, 0);
    }

    private void initAAFbo(int width, int height, int aaSamples) {
        this.fboSceneHandle = GL43C.glGenFramebuffers();
        GL43C.glBindFramebuffer(36160, this.fboSceneHandle);
        this.rboSceneHandle = GL43C.glGenRenderbuffers();
        GL43C.glBindRenderbuffer(36161, this.rboSceneHandle);
        GL43C.glRenderbufferStorageMultisample(36161, aaSamples, 6408, width, height);
        GL43C.glFramebufferRenderbuffer(36160, 36064, 36161, this.rboSceneHandle);
        GL43C.glBindFramebuffer(36160, this.awtContext.getFramebuffer(false));
        GL43C.glBindRenderbuffer(36161, 0);
    }

    private void shutdownAAFbo() {
        if (this.fboSceneHandle != -1) {
            GL43C.glDeleteFramebuffers(this.fboSceneHandle);
            this.fboSceneHandle = -1;
        }
        if (this.rboSceneHandle != -1) {
            GL43C.glDeleteRenderbuffers(this.rboSceneHandle);
            this.rboSceneHandle = -1;
        }
    }

    private void initShadowMapFbo() {
        if (!this.configShadowsEnabled) {
            this.initDummyShadowMap();
            return;
        }
        this.fboShadowMap = GL43C.glGenFramebuffers();
        GL43C.glBindFramebuffer(36160, this.fboShadowMap);
        this.texShadowMap = GL43C.glGenTextures();
        GL43C.glBindTexture(3553, this.texShadowMap);
        GL43C.glTexImage2D(3553, 0, 6402, this.config.shadowResolution().getValue(), this.config.shadowResolution().getValue(), 0, 6402, 5126, 0L);
        GL43C.glTexParameteri(3553, 10241, 9728);
        GL43C.glTexParameteri(3553, 10240, 9728);
        GL43C.glTexParameteri(3553, 10242, 33069);
        GL43C.glTexParameteri(3553, 10243, 33069);
        float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        GL43C.glTexParameterfv(3553, 4100, color);
        GL43C.glFramebufferTexture2D(36160, 36096, 3553, this.texShadowMap, 0);
        GL43C.glDrawBuffer(0);
        GL43C.glReadBuffer(0);
        GL43C.glBindTexture(3553, 0);
        GL43C.glBindFramebuffer(36160, this.awtContext.getFramebuffer(false));
    }

    private void initDummyShadowMap() {
        this.texShadowMap = GL43C.glGenTextures();
        GL43C.glBindTexture(3553, this.texShadowMap);
        GL43C.glTexImage2D(3553, 0, 6402, 1, 1, 0, 6402, 5126, 0L);
        GL43C.glTexParameteri(3553, 10241, 9728);
        GL43C.glTexParameteri(3553, 10240, 9728);
        GL43C.glTexParameteri(3553, 10242, 33069);
        GL43C.glTexParameteri(3553, 10243, 33069);
        GL43C.glBindTexture(3553, 0);
    }

    private void shutdownShadowMapFbo() {
        if (this.texShadowMap != -1) {
            GL43C.glDeleteTextures(this.texShadowMap);
            this.texShadowMap = -1;
        }
        if (this.fboShadowMap != -1) {
            GL43C.glDeleteFramebuffers(this.fboShadowMap);
            this.fboShadowMap = -1;
        }
    }

    @Override
    public void drawScene(int cameraX, int cameraY, int cameraZ, int cameraPitch, int cameraYaw, int plane) {
        this.yaw = this.client.getCameraYaw();
        this.pitch = this.client.getCameraPitch();
        this.viewportOffsetX = this.client.getViewportXOffset();
        this.viewportOffsetY = this.client.getViewportYOffset();
        Scene scene = this.client.getScene();
        scene.setDrawDistance(this.getDrawDistance());
        this.environmentManager.update();
        this.lightManager.update();
        this.targetBufferOffset = 0;
        this.vertexBuffer.clear();
        this.vertexBuffer.ensureCapacity(32);
        IntBuffer uniformBuf = this.vertexBuffer.getBuffer();
        uniformBuf.put(this.yaw).put(this.pitch).put(this.client.getCenterX()).put(this.client.getCenterY()).put(this.client.getScale()).put(cameraX).put(cameraY).put(cameraZ);
        uniformBuf.flip();
        GL43C.glBindBuffer(35345, this.uniformBuffer.glBufferId);
        GL43C.glBufferSubData(35345, 0L, uniformBuf);
        GL43C.glBindBuffer(35345, 0);
        GL43C.glBindBufferBase(35345, 0, this.uniformBuffer.glBufferId);
        uniformBuf.clear();
        GL43C.glBindBuffer(35345, this.materialsUniformBuffer.glBufferId);
        GL43C.glBindBufferBase(35345, 1, this.materialsUniformBuffer.glBufferId);
        GL43C.glBindBuffer(35345, 0);
        if (this.config.maxDynamicLights().getValue() > 0) {
            this.lightsUniformBuf.clear();
            ArrayList<SceneLight> visibleLights = this.lightManager.getVisibleLights(this.getDrawDistance(), this.config.maxDynamicLights().getValue());
            for (SceneLight light : visibleLights) {
                this.lightsUniformBuf.putInt(light.x);
                this.lightsUniformBuf.putInt(light.y);
                this.lightsUniformBuf.putInt(light.z);
                this.lightsUniformBuf.putFloat(light.currentSize);
                this.lightsUniformBuf.putFloat(light.currentColor[0]);
                this.lightsUniformBuf.putFloat(light.currentColor[1]);
                this.lightsUniformBuf.putFloat(light.currentColor[2]);
                this.lightsUniformBuf.putFloat(light.currentStrength);
                this.lightsUniformBuf.put(new byte[((int)Math.ceil(2.0) * 4 - 8) * 4]);
            }
            this.lightsUniformBuf.flip();
            GL43C.glBindBuffer(35345, this.lightsUniformBuffer.glBufferId);
            GL43C.glBufferSubData(35345, 0L, this.lightsUniformBuf);
            this.lightsUniformBuf.clear();
        }
        GL43C.glBindBufferBase(35345, 2, this.lightsUniformBuffer.glBufferId);
        GL43C.glBindBuffer(35345, 0);
    }

    @Override
    public void postDrawScene() {
        this.postDraw();
    }

    private void postDraw() {
        this.vertexBuffer.flip();
        this.uvBuffer.flip();
        this.normalBuffer.flip();
        this.modelBuffer.flip();
        this.modelBufferSmall.flip();
        this.modelBufferUnordered.flip();
        IntBuffer vertexBuffer = this.vertexBuffer.getBuffer();
        FloatBuffer uvBuffer = this.uvBuffer.getBuffer();
        FloatBuffer normalBuffer = this.normalBuffer.getBuffer();
        IntBuffer modelBuffer = this.modelBuffer.getBuffer();
        IntBuffer modelBufferSmall = this.modelBufferSmall.getBuffer();
        IntBuffer modelBufferUnordered = this.modelBufferUnordered.getBuffer();
        this.updateBuffer(this.tmpVertexBuffer, 34962, vertexBuffer, 35048, 4L);
        this.updateBuffer(this.tmpUvBuffer, 34962, uvBuffer, 35048, 4L);
        this.updateBuffer(this.tmpNormalBuffer, 34962, normalBuffer, 35048, 4L);
        this.updateBuffer(this.tmpModelBufferLarge, 34962, modelBuffer, 35048, 4L);
        this.updateBuffer(this.tmpModelBufferSmall, 34962, modelBufferSmall, 35048, 4L);
        this.updateBuffer(this.tmpModelBufferUnordered, 34962, modelBufferUnordered, 35048, 4L);
        this.updateBuffer(this.tmpOutBuffer, 34962, this.targetBufferOffset * 16, 35040, 2L);
        this.updateBuffer(this.tmpOutUvBuffer, 34962, this.targetBufferOffset * 16, 35040, 2L);
        this.updateBuffer(this.tmpOutNormalBuffer, 34962, this.targetBufferOffset * 16, 35040, 2L);
        if (this.computeMode == ComputeMode.OPENCL) {
            this.openCLManager.compute(this.unorderedModels, this.smallModels, this.largeModels, this.sceneVertexBuffer, this.sceneUvBuffer, this.tmpVertexBuffer, this.tmpUvBuffer, this.tmpModelBufferUnordered, this.tmpModelBufferSmall, this.tmpModelBufferLarge, this.tmpOutBuffer, this.tmpOutUvBuffer, this.uniformBuffer, this.tmpOutNormalBuffer, this.sceneNormalBuffer, this.tmpNormalBuffer);
            this.checkGLErrors();
            return;
        }
        GL43C.glUniformBlockBinding(this.glSmallComputeProgram, this.uniBlockSmall, 0);
        GL43C.glUniformBlockBinding(this.glComputeProgram, this.uniBlockLarge, 0);
        GL43C.glUseProgram(this.glUnorderedComputeProgram);
        GL43C.glBindBufferBase(37074, 0, this.tmpModelBufferUnordered.glBufferId);
        GL43C.glBindBufferBase(37074, 1, this.sceneVertexBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 2, this.tmpVertexBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 3, this.tmpOutBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 4, this.tmpOutUvBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 5, this.sceneUvBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 6, this.tmpUvBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 7, this.tmpOutNormalBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 8, this.sceneNormalBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 9, this.tmpNormalBuffer.glBufferId);
        GL43C.glDispatchCompute(this.unorderedModels, 1, 1);
        GL43C.glUseProgram(this.glSmallComputeProgram);
        GL43C.glBindBufferBase(37074, 0, this.tmpModelBufferSmall.glBufferId);
        GL43C.glBindBufferBase(37074, 1, this.sceneVertexBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 2, this.tmpVertexBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 3, this.tmpOutBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 4, this.tmpOutUvBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 5, this.sceneUvBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 6, this.tmpUvBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 7, this.tmpOutNormalBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 8, this.sceneNormalBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 9, this.tmpNormalBuffer.glBufferId);
        GL43C.glDispatchCompute(this.smallModels, 1, 1);
        GL43C.glUseProgram(this.glComputeProgram);
        GL43C.glBindBufferBase(37074, 0, this.tmpModelBufferLarge.glBufferId);
        GL43C.glBindBufferBase(37074, 1, this.sceneVertexBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 2, this.tmpVertexBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 3, this.tmpOutBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 4, this.tmpOutUvBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 5, this.sceneUvBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 6, this.tmpUvBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 7, this.tmpOutNormalBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 8, this.sceneNormalBuffer.glBufferId);
        GL43C.glBindBufferBase(37074, 9, this.tmpNormalBuffer.glBufferId);
        GL43C.glDispatchCompute(this.largeModels, 1, 1);
        this.checkGLErrors();
    }

    @Override
    public void drawScenePaint(int orientation, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z, SceneTilePaint paint, int tileZ, int tileX, int tileY, int zoom, int centerX, int centerY) {
        if (paint.getBufferLen() > 0) {
            int localX = tileX * 128;
            boolean localY = false;
            int localZ = tileY * 128;
            GpuIntBuffer b = this.modelBufferUnordered;
            b.ensureCapacity(16);
            IntBuffer buffer = b.getBuffer();
            int bufferLength = paint.getBufferLen();
            boolean underwaterTerrain = (bufferLength & 1) == 1;
            bufferLength >>= 1;
            if (underwaterTerrain) {
                ++this.unorderedModels;
                buffer.put(paint.getBufferOffset() + (bufferLength /= 2));
                buffer.put(paint.getUvBufferOffset() + bufferLength);
                buffer.put(bufferLength / 3);
                buffer.put(this.targetBufferOffset);
                buffer.put(Integer.MIN_VALUE);
                buffer.put(localX).put(0).put(localZ);
                this.targetBufferOffset += bufferLength;
            }
            ++this.unorderedModels;
            buffer.put(paint.getBufferOffset());
            buffer.put(paint.getUvBufferOffset());
            buffer.put(bufferLength / 3);
            buffer.put(this.targetBufferOffset);
            buffer.put(Integer.MIN_VALUE);
            buffer.put(localX).put(0).put(localZ);
            this.targetBufferOffset += bufferLength;
        }
    }

    @Override
    public void drawSceneModel(int orientation, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z, SceneTileModel model, int tileZ, int tileX, int tileY, int zoom, int centerX, int centerY) {
        if (model.getBufferLen() > 0) {
            int localX = tileX * 128;
            boolean localY = false;
            int localZ = tileY * 128;
            GpuIntBuffer b = this.modelBufferUnordered;
            b.ensureCapacity(16);
            IntBuffer buffer = b.getBuffer();
            int bufferLength = model.getBufferLen();
            boolean underwaterTerrain = (bufferLength & 1) == 1;
            bufferLength >>= 1;
            if (underwaterTerrain) {
                ++this.unorderedModels;
                buffer.put(model.getBufferOffset() + (bufferLength /= 2));
                buffer.put(model.getUvBufferOffset() + bufferLength);
                buffer.put(bufferLength / 3);
                buffer.put(this.targetBufferOffset);
                buffer.put(Integer.MIN_VALUE);
                buffer.put(localX).put(0).put(localZ);
                this.targetBufferOffset += bufferLength;
            }
            ++this.unorderedModels;
            buffer.put(model.getBufferOffset());
            buffer.put(model.getUvBufferOffset());
            buffer.put(bufferLength / 3);
            buffer.put(this.targetBufferOffset);
            buffer.put(Integer.MIN_VALUE);
            buffer.put(localX).put(0).put(localZ);
            this.targetBufferOffset += bufferLength;
        }
    }

    @Override
    public void draw(int overlayColor) {
        this.drawFrame(overlayColor);
    }

    private void prepareInterfaceTexture(int canvasWidth, int canvasHeight) {
        boolean fixed = this.client.isResized();
        if (!fixed) {
            canvasWidth = this.client.getRealDimensions().width;
            canvasHeight = this.client.getRealDimensions().height;
        }
        if (canvasWidth != this.lastCanvasWidth || canvasHeight != this.lastCanvasHeight) {
            this.lastCanvasWidth = canvasWidth;
            this.lastCanvasHeight = canvasHeight;
            GL43C.glBindBuffer(35052, this.interfacePbo);
            GL43C.glBufferData(35052, (long)(canvasWidth * canvasHeight) * 4L, 35040);
            GL43C.glBindBuffer(35052, 0);
            GL43C.glBindTexture(3553, this.interfaceTexture);
            GL43C.glTexImage2D(3553, 0, 6408, canvasWidth, canvasHeight, 0, 32993, 5121, 0L);
            GL43C.glBindTexture(3553, 0);
        }
        BufferProvider bufferProvider = this.client.getBufferProvider();
        int[] pixels = bufferProvider.getPixels();
        int width = bufferProvider.getWidth();
        int height = bufferProvider.getHeight();
        GL43C.glBindBuffer(35052, this.interfacePbo);
        GL43C.glMapBuffer(35052, 35001).asIntBuffer().put(pixels, 0, width * height);
        GL43C.glUnmapBuffer(35052);
        GL43C.glBindTexture(3553, this.interfaceTexture);
        GL43C.glTexSubImage2D(3553, 0, 0, 0, width, height, 32993, 33639, 0L);
        GL43C.glBindBuffer(35052, 0);
        GL43C.glBindTexture(3553, 0);
    }

    private void drawFrame(int overlayColor) {
        if (System.currentTimeMillis() - this.lastFrameTime > 60000L) {
            log.debug("resetting the plugin after probable OS suspend");
            this.shutDown();
            this.startUp();
            return;
        }
        this.animationCurrent += (float)(System.currentTimeMillis() - this.lastFrameTime) / 1000.0f;
        this.lastFrameTime = System.currentTimeMillis();
        int canvasHeight = this.client.getCanvasHeight();
        int canvasWidth = this.client.getCanvasWidth();
        try {
            this.prepareInterfaceTexture(canvasWidth, canvasHeight);
        }
        catch (Exception ex) {
            log.warn("prepareInterfaceTexture exception", ex);
            this.shutDown();
            this.startUp();
            return;
        }
        GL43C.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        GL43C.glClear(16384);
        TextureProvider textureProvider = this.client.getTextureProvider();
        if (textureProvider != null && this.client.getGameState().getState() >= GameState.LOADING.getState()) {
            int i;
            boolean aaEnabled;
            int plane;
            int anisotropicFilteringLevel;
            Texture[] textures = textureProvider.getTextures();
            if (this.textureArrayId == -1) {
                this.textureArrayId = this.textureManager.initTextureArray(textureProvider);
            }
            if (this.textureHDArrayId == -1) {
                this.textureHDArrayId = this.textureManager.initTextureHDArray(textureProvider);
            }
            if (this.lastAnisotropicFilteringLevel != (anisotropicFilteringLevel = this.config.anisotropicFilteringLevel())) {
                if (this.textureArrayId != -1) {
                    this.textureManager.setAnisotropicFilteringLevel(this.textureArrayId, anisotropicFilteringLevel, false);
                }
                if (this.textureHDArrayId != -1) {
                    this.textureManager.setAnisotropicFilteringLevel(this.textureHDArrayId, anisotropicFilteringLevel, true);
                }
                this.lastAnisotropicFilteringLevel = anisotropicFilteringLevel;
            }
            if (this.isInHouse && this.previousPlane != (plane = this.client.getPlane())) {
                this.reloadScene();
                this.previousPlane = plane;
            }
            int viewportHeight = this.client.getViewportHeight();
            int viewportWidth = this.client.getViewportWidth();
            int renderWidthOff = this.viewportOffsetX;
            int renderHeightOff = this.viewportOffsetY;
            int renderCanvasHeight = canvasHeight;
            int renderViewportHeight = viewportHeight;
            int renderViewportWidth = viewportWidth;
            if (this.client.isStretchedEnabled()) {
                Dimension dim = this.client.getStretchedDimensions();
                renderCanvasHeight = dim.height;
                double scaleFactorY = dim.getHeight() / (double)canvasHeight;
                double scaleFactorX = dim.getWidth() / (double)canvasWidth;
                boolean padding = true;
                renderViewportHeight = (int)Math.ceil(scaleFactorY * (double)renderViewportHeight) + 2;
                renderViewportWidth = (int)Math.ceil(scaleFactorX * (double)renderViewportWidth) + 2;
                renderHeightOff = (int)Math.floor(scaleFactorY * (double)renderHeightOff) - 1;
                renderWidthOff = (int)Math.floor(scaleFactorX * (double)renderWidthOff) - 1;
            }
            if (this.computeMode == ComputeMode.OPENCL) {
                this.openCLManager.finish();
            } else {
                GL43C.glMemoryBarrier(8192);
            }
            int vertexBuffer = this.tmpOutBuffer.glBufferId;
            int uvBuffer = this.tmpOutUvBuffer.glBufferId;
            int normalBuffer = this.tmpOutNormalBuffer.glBufferId;
            this.textureOffsets = new float[textures.length * 2];
            for (int id = 0; id < textures.length; ++id) {
                Texture texture = textures[id];
                if (texture == null) continue;
                textureProvider.load(id);
                this.textureOffsets[id * 2] = texture.getU();
                this.textureOffsets[id * 2 + 1] = texture.getV();
            }
            if (this.client.getGameState() != GameState.LOADING) {
                this.camTarget = this.getCameraFocalPoint();
            }
            float[] lightProjectionMatrix = Mat4.identity();
            float lightPitch = this.environmentManager.currentLightPitch;
            float lightYaw = this.environmentManager.currentLightYaw;
            if (this.configShadowsEnabled && this.fboShadowMap != -1 && this.environmentManager.currentDirectionalStrength > 0.0f) {
                GL43C.glViewport(0, 0, this.config.shadowResolution().getValue(), this.config.shadowResolution().getValue());
                GL43C.glBindFramebuffer(36160, this.fboShadowMap);
                GL43C.glClear(256);
                GL43C.glUseProgram(this.glShadowProgram);
                int camX = this.camTarget[0];
                int camY = this.camTarget[1];
                int camZ = this.camTarget[2];
                int drawDistanceSceneUnits = Math.min(this.config.shadowDistance().getValue(), this.getDrawDistance()) * 128 / 2;
                int east = Math.min(camX + drawDistanceSceneUnits, 13312);
                int west = Math.max(camX - drawDistanceSceneUnits, 0);
                int north = Math.min(camY + drawDistanceSceneUnits, 13312);
                int south = Math.max(camY - drawDistanceSceneUnits, 0);
                int width = east - west;
                int height = north - south;
                int near = 10000;
                int maxDrawDistance = 90;
                float maxScale = 0.7f;
                float minScale = 0.4f;
                float scaleMultiplier = 1.0f - (float)this.getDrawDistance() / 63.0f;
                float scale = HDUtils.lerp(0.7f, 0.4f, scaleMultiplier);
                Mat4.mul(lightProjectionMatrix, Mat4.scale(scale, scale, scale));
                Mat4.mul(lightProjectionMatrix, Mat4.ortho(width, height, 10000.0f));
                Mat4.mul(lightProjectionMatrix, Mat4.rotateX((float)((double)lightPitch * (Math.PI / 180))));
                Mat4.mul(lightProjectionMatrix, Mat4.rotateY((float)(-((double)lightYaw * (Math.PI / 180)))));
                Mat4.mul(lightProjectionMatrix, Mat4.translate(-((float)width / 2.0f + (float)west), -camZ, -((float)height / 2.0f + (float)south)));
                GL43C.glUniformMatrix4fv(this.uniShadowLightProjectionMatrix, false, lightProjectionMatrix);
                GL43C.glUniformBlockBinding(this.glShadowProgram, this.uniShadowBlockMaterials, 1);
                GL43C.glUniform1i(this.uniShadowTexturesHD, 2);
                GL43C.glUniform2fv(this.uniShadowTextureOffsets, this.textureOffsets);
                GL43C.glEnable(2884);
                GL43C.glEnable(2929);
                GL43C.glBindVertexArray(this.vaoHandle);
                GL43C.glEnableVertexAttribArray(0);
                GL43C.glBindBuffer(34962, vertexBuffer);
                GL43C.glVertexAttribIPointer(0, 4, 5124, 0, 0L);
                GL43C.glEnableVertexAttribArray(1);
                GL43C.glBindBuffer(34962, uvBuffer);
                GL43C.glVertexAttribPointer(1, 4, 5126, false, 0, 0L);
                GL43C.glDrawArrays(4, 0, this.targetBufferOffset);
                GL43C.glDisable(2884);
                GL43C.glDisable(2929);
                GL43C.glBindFramebuffer(36160, this.awtContext.getFramebuffer(false));
                GL43C.glUseProgram(0);
            }
            this.glDpiAwareViewport(renderWidthOff, renderCanvasHeight - renderViewportHeight - renderHeightOff, renderViewportWidth, renderViewportHeight);
            GL43C.glUseProgram(this.glProgram);
            GL43C.glActiveTexture(33987);
            GL43C.glBindTexture(3553, this.texShadowMap);
            GL43C.glActiveTexture(33984);
            AntiAliasingMode antiAliasingMode = this.config.antiAliasingMode();
            boolean bl = aaEnabled = antiAliasingMode != AntiAliasingMode.DISABLED;
            if (aaEnabled) {
                int stretchedCanvasHeight;
                GL43C.glEnable(32925);
                Dimension stretchedDimensions = this.client.getStretchedDimensions();
                int stretchedCanvasWidth = this.client.isStretchedEnabled() ? stretchedDimensions.width : canvasWidth;
                int n = stretchedCanvasHeight = this.client.isStretchedEnabled() ? stretchedDimensions.height : canvasHeight;
                if (this.lastStretchedCanvasWidth != stretchedCanvasWidth || this.lastStretchedCanvasHeight != stretchedCanvasHeight || this.lastAntiAliasingMode != antiAliasingMode) {
                    this.shutdownAAFbo();
                    GL43C.glBindFramebuffer(36160, this.awtContext.getFramebuffer(false));
                    int forcedAASamples = GL43C.glGetInteger(32937);
                    int maxSamples = GL43C.glGetInteger(36183);
                    int samples = forcedAASamples != 0 ? forcedAASamples : Math.min(antiAliasingMode.getSamples(), maxSamples);
                    log.debug("AA samples: {}, max samples: {}, forced samples: {}", samples, maxSamples, forcedAASamples);
                    this.initAAFbo(stretchedCanvasWidth, stretchedCanvasHeight, samples);
                    this.lastStretchedCanvasWidth = stretchedCanvasWidth;
                    this.lastStretchedCanvasHeight = stretchedCanvasHeight;
                }
                GL43C.glBindFramebuffer(36009, this.fboSceneHandle);
            } else {
                GL43C.glDisable(32925);
                this.shutdownAAFbo();
            }
            this.lastAntiAliasingMode = antiAliasingMode;
            float[] fogColor = this.hasLoggedIn ? this.environmentManager.getFogColor() : EnvironmentManager.BLACK_COLOR;
            for (int i2 = 0; i2 < fogColor.length; ++i2) {
                fogColor[i2] = HDUtils.linearToGamma(fogColor[i2]);
            }
            GL43C.glClearColor(fogColor[0], fogColor[1], fogColor[2], 1.0f);
            GL43C.glClear(16384);
            int drawDistance = this.getDrawDistance();
            int fogDepth = this.config.fogDepth();
            fogDepth *= 10;
            if (this.config.fogDepthMode() == FogDepthMode.DYNAMIC) {
                fogDepth = this.environmentManager.currentFogDepth;
            } else if (this.config.fogDepthMode() == FogDepthMode.NONE) {
                fogDepth = 0;
            }
            GL43C.glUniform1i(this.uniUseFog, fogDepth > 0 ? 1 : 0);
            GL43C.glUniform1i(this.uniFogDepth, fogDepth);
            GL43C.glUniform4f(this.uniFogColor, fogColor[0], fogColor[1], fogColor[2], 1.0f);
            GL43C.glUniform1i(this.uniDrawDistance, drawDistance * 128);
            GL43C.glUniform1i(this.uniColorBlindMode, this.config.colorBlindMode().ordinal());
            float[] waterColor = this.environmentManager.currentWaterColor;
            float[] waterColorHSB = Color.RGBtoHSB((int)(waterColor[0] * 255.0f), (int)(waterColor[1] * 255.0f), (int)(waterColor[2] * 255.0f), null);
            float lightBrightnessMultiplier = 0.8f;
            float midBrightnessMultiplier = 0.45f;
            float darkBrightnessMultiplier = 0.05f;
            float[] waterColorLight = new Color(Color.HSBtoRGB(waterColorHSB[0], waterColorHSB[1], waterColorHSB[2] * lightBrightnessMultiplier)).getRGBColorComponents(null);
            float[] waterColorMid = new Color(Color.HSBtoRGB(waterColorHSB[0], waterColorHSB[1], waterColorHSB[2] * midBrightnessMultiplier)).getRGBColorComponents(null);
            float[] waterColorDark = new Color(Color.HSBtoRGB(waterColorHSB[0], waterColorHSB[1], waterColorHSB[2] * darkBrightnessMultiplier)).getRGBColorComponents(null);
            for (i = 0; i < waterColorLight.length; ++i) {
                waterColorLight[i] = HDUtils.linearToGamma(waterColorLight[i]);
            }
            for (i = 0; i < waterColorMid.length; ++i) {
                waterColorMid[i] = HDUtils.linearToGamma(waterColorMid[i]);
            }
            for (i = 0; i < waterColorDark.length; ++i) {
                waterColorDark[i] = HDUtils.linearToGamma(waterColorDark[i]);
            }
            GL43C.glUniform3f(this.uniWaterColorLight, waterColorLight[0], waterColorLight[1], waterColorLight[2]);
            GL43C.glUniform3f(this.uniWaterColorMid, waterColorMid[0], waterColorMid[1], waterColorMid[2]);
            GL43C.glUniform3f(this.uniWaterColorDark, waterColorDark[0], waterColorDark[1], waterColorDark[2]);
            float ambientStrength = this.environmentManager.currentAmbientStrength;
            ambientStrength = (float)((double)ambientStrength * ((double)this.config.brightness() / 20.0));
            GL43C.glUniform1f(this.uniAmbientStrength, ambientStrength);
            float[] ambientColor = this.environmentManager.currentAmbientColor;
            GL43C.glUniform3f(this.uniAmbientColor, ambientColor[0], ambientColor[1], ambientColor[2]);
            float lightStrength = this.environmentManager.currentDirectionalStrength;
            lightStrength = (float)((double)lightStrength * ((double)this.config.brightness() / 20.0));
            GL43C.glUniform1f(this.uniLightStrength, lightStrength);
            float[] lightColor = this.environmentManager.currentDirectionalColor;
            GL43C.glUniform3f(this.uniLightColor, lightColor[0], lightColor[1], lightColor[2]);
            float underglowStrength = this.environmentManager.currentUnderglowStrength;
            GL43C.glUniform1f(this.uniUnderglowStrength, underglowStrength);
            float[] underglowColor = this.environmentManager.currentUnderglowColor;
            GL43C.glUniform3f(this.uniUnderglowColor, underglowColor[0], underglowColor[1], underglowColor[2]);
            float groundFogStart = this.environmentManager.currentGroundFogStart;
            GL43C.glUniform1f(this.uniGroundFogStart, groundFogStart);
            float groundFogEnd = this.environmentManager.currentGroundFogEnd;
            GL43C.glUniform1f(this.uniGroundFogEnd, groundFogEnd);
            float groundFogOpacity = this.environmentManager.currentGroundFogOpacity;
            groundFogOpacity = this.config.groundFog() ? groundFogOpacity : 0.0f;
            GL43C.glUniform1f(this.uniGroundFogOpacity, groundFogOpacity);
            GL43C.glUniform1f(this.uniLightningBrightness, this.environmentManager.lightningBrightness);
            GL43C.glUniform1i(this.uniPointLightsCount, this.config.maxDynamicLights().getValue() > 0 ? this.lightManager.visibleLightsCount : 0);
            GL43C.glUniform1f(this.uniSaturation, this.config.saturation().getAmount());
            GL43C.glUniform1f(this.uniContrast, this.config.contrast().getAmount());
            GL43C.glUniform1i(this.uniUnderwaterEnvironment, this.environmentManager.isUnderwater() ? 1 : 0);
            GL43C.glUniform1i(this.uniUnderwaterCaustics, this.config.underwaterCaustics() ? 1 : 0);
            GL43C.glUniform3fv(this.uniUnderwaterCausticsColor, this.environmentManager.currentUnderwaterCausticsColor);
            GL43C.glUniform1f(this.uniUnderwaterCausticsStrength, this.environmentManager.currentUnderwaterCausticsStrength);
            double lightPitchRadians = Math.toRadians(lightPitch);
            double lightYawRadians = Math.toRadians(lightYaw);
            double lightX = Math.cos(lightPitchRadians) * Math.sin(lightYawRadians);
            double lightY = Math.sin(lightPitchRadians);
            double lightZ = Math.cos(lightPitchRadians) * Math.cos(lightYawRadians);
            GL43C.glUniform1f(this.uniLightX, (float)lightX);
            GL43C.glUniform1f(this.uniLightY, (float)lightY);
            GL43C.glUniform1f(this.uniLightZ, (float)lightZ);
            float shadowPixelsPerTile = (float)this.config.shadowResolution().getValue() / (float)this.config.shadowDistance().getValue();
            float maxBias = 26.0f * (float)Math.pow(0.925f, 0.4f * shadowPixelsPerTile + -10.0f) + 13.0f;
            GL43C.glUniform1f(this.uniShadowMaxBias, maxBias / 10000.0f);
            GL43C.glUniform1i(this.uniShadowsEnabled, this.configShadowsEnabled ? 1 : 0);
            float[] projectionMatrix = Mat4.scale(this.client.getScale(), this.client.getScale(), 1.0f);
            Mat4.mul(projectionMatrix, Mat4.projection(viewportWidth, viewportHeight, 50.0f));
            Mat4.mul(projectionMatrix, Mat4.rotateX((float)(-(Math.PI - (double)this.pitch * 0.0030679615757712823))));
            Mat4.mul(projectionMatrix, Mat4.rotateY((float)((double)this.yaw * 0.0030679615757712823)));
            Mat4.mul(projectionMatrix, Mat4.translate(-this.client.getCameraX2(), -this.client.getCameraY2(), -this.client.getCameraZ2()));
            GL43C.glUniformMatrix4fv(this.uniProjectionMatrix, false, projectionMatrix);
            GL43C.glUniformMatrix4fv(this.uniLightProjectionMatrix, false, lightProjectionMatrix);
            GL43C.glUniformBlockBinding(this.glProgram, this.uniBlockMain, 0);
            GL43C.glUniformBlockBinding(this.glProgram, this.uniBlockMaterials, 1);
            GL43C.glUniformBlockBinding(this.glProgram, this.uniBlockPointLights, 2);
            GL43C.glUniform2fv(this.uniTextureOffsets, this.textureOffsets);
            GL43C.glUniform1f(this.uniAnimationCurrent, this.animationCurrent);
            GL43C.glEnable(2884);
            GL43C.glCullFace(1029);
            GL43C.glEnable(3042);
            GL43C.glBlendFuncSeparate(770, 771, 1, 1);
            GL43C.glBindVertexArray(this.vaoHandle);
            GL43C.glEnableVertexAttribArray(0);
            GL43C.glBindBuffer(34962, vertexBuffer);
            GL43C.glVertexAttribIPointer(0, 4, 5124, 0, 0L);
            GL43C.glEnableVertexAttribArray(1);
            GL43C.glBindBuffer(34962, uvBuffer);
            GL43C.glVertexAttribPointer(1, 4, 5126, false, 0, 0L);
            GL43C.glEnableVertexAttribArray(2);
            GL43C.glBindBuffer(34962, normalBuffer);
            GL43C.glVertexAttribPointer(2, 4, 5126, false, 0, 0L);
            GL43C.glDrawArrays(4, 0, this.targetBufferOffset);
            GL43C.glDisable(3042);
            GL43C.glDisable(2884);
            GL43C.glUseProgram(0);
            if (aaEnabled) {
                GL43C.glBindFramebuffer(36008, this.fboSceneHandle);
                GL43C.glBindFramebuffer(36009, this.awtContext.getFramebuffer(false));
                GL43C.glBlitFramebuffer(0, 0, this.lastStretchedCanvasWidth, this.lastStretchedCanvasHeight, 0, 0, this.lastStretchedCanvasWidth, this.lastStretchedCanvasHeight, 16384, 9728);
                GL43C.glBindFramebuffer(36008, this.awtContext.getFramebuffer(false));
            }
            this.vertexBuffer.clear();
            this.uvBuffer.clear();
            this.normalBuffer.clear();
            this.modelBuffer.clear();
            this.modelBufferSmall.clear();
            this.modelBufferUnordered.clear();
            this.unorderedModels = 0;
            this.largeModels = 0;
            this.smallModels = 0;
            this.tempOffset = 0;
            this.tempUvOffset = 0;
            this.tempModelInfoMap.clear();
            if (this.nextSceneReload != 0L && this.nextSceneReload <= System.currentTimeMillis()) {
                this.lightManager.reset();
                this.uploadScene();
                this.nextSceneReload = 0L;
            }
        }
        this.drawUi(overlayColor, canvasHeight, canvasWidth);
        this.awtContext.swapBuffers();
        GL43C.glBindFramebuffer(36160, this.awtContext.getFramebuffer(false));
        this.checkGLErrors();
    }

    private void drawUi(int overlayColor, int canvasHeight, int canvasWidth) {
        GL43C.glEnable(3042);
        GL43C.glBlendFunc(1, 771);
        GL43C.glBindTexture(3553, this.interfaceTexture);
        UIScalingMode uiScalingMode = this.config.uiScalingMode();
        GL43C.glUseProgram(this.glUiProgram);
        GL43C.glUniform1i(this.uniTex, 0);
        GL43C.glUniform1i(this.uniTexSamplingMode, uiScalingMode.getMode());
        GL43C.glUniform2i(this.uniTexSourceDimensions, canvasWidth, canvasHeight);
        GL43C.glUniform1i(this.uniUiColorBlindMode, this.config.colorBlindMode().ordinal());
        GL43C.glUniform4f(this.uniUiAlphaOverlay, (float)(overlayColor >> 16 & 0xFF) / 255.0f, (float)(overlayColor >> 8 & 0xFF) / 255.0f, (float)(overlayColor & 0xFF) / 255.0f, (float)(overlayColor >>> 24) / 255.0f);
        if (this.client.isStretchedEnabled()) {
            Dimension dim = this.client.getStretchedDimensions();
            this.glDpiAwareViewport(0, 0, dim.width, dim.height);
            GL43C.glUniform2i(this.uniTexTargetDimensions, dim.width, dim.height);
        } else {
            this.glDpiAwareViewport(0, 0, canvasWidth, canvasHeight);
            GL43C.glUniform2i(this.uniTexTargetDimensions, canvasWidth, canvasHeight);
        }
        if (this.client.isStretchedEnabled()) {
            int function = uiScalingMode == UIScalingMode.LINEAR ? 9729 : 9728;
            GL43C.glTexParameteri(3553, 10241, function);
            GL43C.glTexParameteri(3553, 10240, function);
        }
        GL43C.glBindVertexArray(this.vaoUiHandle);
        GL43C.glDrawArrays(6, 0, 4);
        GL43C.glBindTexture(3553, 0);
        GL43C.glBindVertexArray(0);
        GL43C.glUseProgram(0);
        GL43C.glBlendFunc(770, 771);
        GL43C.glDisable(3042);
        this.vertexBuffer.clear();
    }

    private Image screenshot() {
        int width = this.client.getCanvasWidth();
        int height = this.client.getCanvasHeight();
        if (this.client.isStretchedEnabled()) {
            Dimension dim = this.client.getStretchedDimensions();
            width = dim.width;
            height = dim.height;
        }
        if (OSType.getOSType() != OSType.MacOS) {
            Graphics2D graphics = (Graphics2D)this.canvas.getGraphics();
            AffineTransform t = graphics.getTransform();
            width = this.getScaledValue(t.getScaleX(), width);
            height = this.getScaledValue(t.getScaleY(), height);
            graphics.dispose();
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(width * height * 4).order(ByteOrder.nativeOrder());
        GL43C.glReadBuffer(this.awtContext.getBufferMode());
        GL43C.glReadPixels(0, 0, width, height, 6408, 5121, buffer);
        BufferedImage image = new BufferedImage(width, height, 1);
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int r = buffer.get() & 0xFF;
                int g2 = buffer.get() & 0xFF;
                int b = buffer.get() & 0xFF;
                buffer.get();
                pixels[(height - y - 1) * width + x] = r << 16 | g2 << 8 | b;
            }
        }
        return image;
    }

    @Override
    public void animate(Texture texture, int diff) {
        this.textureManager.animate(texture, diff);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        switch (gameStateChanged.getGameState()) {
            case LOGGED_IN: {
                this.uploadScene();
                this.checkGLErrors();
                break;
            }
            case LOGIN_SCREEN: {
                break;
            }
            default: {
                this.lightManager.reset();
            }
        }
    }

    private void uploadScene() {
        this.modelPusher.clearModelCache();
        this.vertexBuffer.clear();
        this.uvBuffer.clear();
        this.normalBuffer.clear();
        this.generateHDSceneData();
        this.sceneUploader.upload(this.client.getScene(), this.vertexBuffer, this.uvBuffer, this.normalBuffer);
        this.vertexBuffer.flip();
        this.uvBuffer.flip();
        this.normalBuffer.flip();
        IntBuffer vertexBuffer = this.vertexBuffer.getBuffer();
        FloatBuffer uvBuffer = this.uvBuffer.getBuffer();
        FloatBuffer normalBuffer = this.normalBuffer.getBuffer();
        this.updateBuffer(this.sceneVertexBuffer, 34962, vertexBuffer, 35046, 4L);
        this.updateBuffer(this.sceneUvBuffer, 34962, uvBuffer, 35046, 4L);
        this.updateBuffer(this.sceneNormalBuffer, 34962, normalBuffer, 35046, 4L);
        GL43C.glBindBuffer(34962, 0);
        vertexBuffer.clear();
        uvBuffer.clear();
        normalBuffer.clear();
    }

    void generateHDSceneData() {
        this.environmentManager.loadSceneEnvironments();
        this.lightManager.loadSceneLights();
        long procGenTimer = System.currentTimeMillis();
        long startTime = System.currentTimeMillis();
        this.proceduralGenerator.generateUnderwaterTerrain(this.client.getScene());
        long timerGenerateUnderwaterTerrain = (int)(System.currentTimeMillis() - startTime);
        startTime = System.currentTimeMillis();
        this.proceduralGenerator.calculateTerrainNormals(this.client.getScene());
        long timerCalculateTerrainNormals = (int)(System.currentTimeMillis() - startTime);
        startTime = System.currentTimeMillis();
        this.proceduralGenerator.generateTerrainData(this.client.getScene());
        long timerGenerateTerrainData = (int)(System.currentTimeMillis() - startTime);
        log.debug("procedural data generation took {}ms to complete", (Object)(System.currentTimeMillis() - procGenTimer));
        log.debug("-- calculateTerrainNormals: {}ms", (Object)timerCalculateTerrainNormals);
        log.debug("-- generateTerrainData: {}ms", (Object)timerGenerateTerrainData);
        log.debug("-- generateUnderwaterTerrain: {}ms", (Object)timerGenerateUnderwaterTerrain);
    }

    @Subscribe(priority=-1.0f)
    public void onBeforeRender(BeforeRender event) {
        if (this.skyboxColorChanged) {
            this.skyboxColorChanged = false;
            this.environmentManager.updateSkyColor();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        String key;
        if (event.getGroup().equals("skybox") && this.config.defaultSkyColor() == DefaultSkyColor.RUNELITE) {
            this.skyboxColorChanged = true;
            return;
        }
        if (!event.getGroup().equals("hd")) {
            return;
        }
        switch (key = event.getKey()) {
            case "groundTextures": {
                this.configGroundTextures = this.config.groundTextures();
                this.reloadScene();
                break;
            }
            case "groundBlending": {
                this.configGroundBlending = this.config.groundBlending();
                this.reloadScene();
                break;
            }
            case "shadowsEnabled": {
                this.configShadowsEnabled = this.config.shadowsEnabled();
                this.modelPusher.clearModelCache();
                this.clientThread.invoke(() -> {
                    this.shutdownShadowMapFbo();
                    this.initShadowMapFbo();
                });
                break;
            }
            case "shadowResolution": {
                this.clientThread.invoke(() -> {
                    this.shutdownShadowMapFbo();
                    this.initShadowMapFbo();
                });
                break;
            }
            case "objectTextures": {
                this.configObjectTextures = this.config.objectTextures();
                this.reloadScene();
                break;
            }
            case "tzhaarHD": {
                this.configTzhaarHD = this.config.tzhaarHD();
                this.reloadScene();
                break;
            }
            case "winterTheme0": {
                this.configWinterTheme = this.config.winterTheme();
                this.reloadScene();
                break;
            }
            case "projectileLights": {
                this.configProjectileLights = this.config.projectileLights();
                break;
            }
            case "npcLights": {
                this.configNpcLights = this.config.npcLights();
                break;
            }
            case "expandShadowDraw": {
                this.configExpandShadowDraw = this.config.expandShadowDraw();
                break;
            }
            case "macosIntelWorkaround": {
                this.recompilePrograms();
                break;
            }
            case "unlockFps": 
            case "vsyncMode": 
            case "fpsTarget": {
                log.debug("Rebuilding sync mode");
                this.clientThread.invokeLater(this::setupSyncMode);
                break;
            }
            case "hdInfernalTexture": {
                this.configHdInfernalTexture = this.config.hdInfernalTexture();
                break;
            }
            case "hideBakedEffects": {
                this.modelPusher.clearModelCache();
            }
        }
    }

    private void setupSyncMode() {
        boolean unlockFps = this.config.unlockFps();
        this.client.setUnlockedFps(unlockFps);
        HdPluginConfig.SyncMode syncMode = unlockFps ? this.config.syncMode() : HdPluginConfig.SyncMode.OFF;
        int swapInterval = 0;
        switch (syncMode) {
            case ON: {
                swapInterval = 1;
                break;
            }
            case OFF: {
                swapInterval = 0;
                break;
            }
            case ADAPTIVE: {
                swapInterval = -1;
            }
        }
        int actualSwapInterval = this.awtContext.setSwapInterval(swapInterval);
        if (actualSwapInterval != swapInterval) {
            log.info("unsupported swap interval {}, got {}", (Object)swapInterval, (Object)actualSwapInterval);
        }
        this.client.setUnlockedFpsTarget(actualSwapInterval == 0 ? this.config.fpsTarget() : 0);
        this.checkGLErrors();
    }

    private void reloadScene() {
        this.nextSceneReload = System.currentTimeMillis();
    }

    private boolean isVisible(Model model, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z) {
        int yheight;
        int ybottom;
        int ry;
        int var20;
        int var17;
        int rx;
        int var16;
        model.calculateBoundsCylinder();
        int XYZMag = model.getXYZMag();
        int bottomY = model.getBottomY();
        int zoom = this.configShadowsEnabled && this.configExpandShadowDraw ? this.client.get3dZoom() / 2 : this.client.get3dZoom();
        int modelHeight = model.getModelHeight();
        int Rasterizer3D_clipMidX2 = this.client.getRasterizer3D_clipMidX2();
        int Rasterizer3D_clipNegativeMidX = this.client.getRasterizer3D_clipNegativeMidX();
        int Rasterizer3D_clipNegativeMidY = this.client.getRasterizer3D_clipNegativeMidY();
        int Rasterizer3D_clipMidY2 = this.client.getRasterizer3D_clipMidY2();
        int var11 = yawCos * z - yawSin * x >> 16;
        int var12 = pitchSin * y + pitchCos * var11 >> 16;
        int var13 = pitchCos * XYZMag >> 16;
        int depth = var12 + var13;
        if (depth > 50 && (var16 = ((rx = z * yawSin + yawCos * x >> 16) - XYZMag) * zoom) / depth < Rasterizer3D_clipMidX2 && (var17 = (rx + XYZMag) * zoom) / depth > Rasterizer3D_clipNegativeMidX && (var20 = ((ry = pitchCos * y - var11 * pitchSin >> 16) + (ybottom = (pitchCos * bottomY >> 16) + (yheight = pitchSin * XYZMag >> 16))) * zoom) / depth > Rasterizer3D_clipNegativeMidY) {
            int ytop = (pitchCos * modelHeight >> 16) + yheight;
            int var22 = (ry - ytop) * zoom;
            return var22 / depth < Rasterizer3D_clipMidY2;
        }
        return true;
    }

    @Override
    public void draw(Renderable renderable, int orientation, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z, int id, int hash) {
        Model model;
        Model model2 = model = renderable instanceof Model ? (Model)renderable : renderable.getModel();
        if (model == null || model.getFaceCount() == 0) {
            return;
        }
        if (model.getSceneId() == this.sceneUploader.sceneId) {
            model.calculateBoundsCylinder();
            if (!this.isVisible(model, pitchSin, pitchCos, yawSin, yawCos, x, y, z)) {
                return;
            }
            if ((model.getBufferOffset() & 3) == 3) {
                return;
            }
            model.calculateExtreme(orientation);
            this.client.checkClickbox(model, orientation, pitchSin, pitchCos, yawSin, yawCos, x, y, z, hash);
            int faceCount = Math.min(8192, model.getFaceCount());
            int uvOffset = model.getUvBufferOffset();
            HdPlugin.eightIntWrite[0] = model.getBufferOffset() >> 2;
            HdPlugin.eightIntWrite[1] = uvOffset;
            HdPlugin.eightIntWrite[2] = faceCount;
            HdPlugin.eightIntWrite[3] = this.targetBufferOffset;
            HdPlugin.eightIntWrite[4] = Integer.MIN_VALUE | model.getRadius() << 12 | orientation;
            HdPlugin.eightIntWrite[5] = x + this.client.getCameraX2();
            HdPlugin.eightIntWrite[6] = y + this.client.getCameraY2();
            HdPlugin.eightIntWrite[7] = z + this.client.getCameraZ2();
            this.bufferForTriangles(faceCount).ensureCapacity(8).put(eightIntWrite);
            this.targetBufferOffset += faceCount * 3;
        } else {
            if (model != renderable) {
                renderable.setModelHeight(model.getModelHeight());
            }
            model.calculateBoundsCylinder();
            if (!this.isVisible(model, pitchSin, pitchCos, yawSin, yawCos, x, y, z)) {
                return;
            }
            if ((model.getBufferOffset() & 3) == 3) {
                return;
            }
            model.calculateExtreme(orientation);
            this.client.checkClickbox(model, orientation, pitchSin, pitchCos, yawSin, yawCos, x, y, z, hash);
            HdPlugin.eightIntWrite[3] = this.targetBufferOffset;
            HdPlugin.eightIntWrite[4] = model.getRadius() << 12 | orientation;
            HdPlugin.eightIntWrite[5] = x + this.client.getCameraX2();
            HdPlugin.eightIntWrite[6] = y + this.client.getCameraY2();
            HdPlugin.eightIntWrite[7] = z + this.client.getCameraZ2();
            this.modelHasher.setModel(model);
            int batchHash = this.modelHasher.calculateBatchHash();
            TempModelInfo tempModelInfo = this.tempModelInfoMap.get(batchHash);
            if (this.config.disableModelBatching() || tempModelInfo == null || tempModelInfo.getFaceCount() != model.getFaceCount()) {
                int[] lengths = this.modelPusher.pushModel(renderable, model, this.vertexBuffer, this.uvBuffer, this.normalBuffer, 0, 0, 0, ObjectProperties.NONE, ObjectType.NONE, this.config.disableModelCaching(), this.modelHasher.calculateColorCacheHash());
                int faceCount = lengths[0] / 3;
                int actualTempUvOffset = lengths[1] > 0 ? this.tempUvOffset : -1;
                tempModelInfo = new TempModelInfo();
                tempModelInfo.setTempOffset(this.tempOffset).setTempUvOffset(actualTempUvOffset).setFaceCount(faceCount);
                this.tempModelInfoMap.put(batchHash, tempModelInfo);
                HdPlugin.eightIntWrite[0] = this.tempOffset;
                HdPlugin.eightIntWrite[1] = actualTempUvOffset;
                HdPlugin.eightIntWrite[2] = faceCount;
                this.bufferForTriangles(faceCount).ensureCapacity(8).put(eightIntWrite);
                this.tempOffset += lengths[0];
                this.tempUvOffset += lengths[1];
                this.targetBufferOffset += lengths[0];
            } else {
                HdPlugin.eightIntWrite[0] = tempModelInfo.getTempOffset();
                HdPlugin.eightIntWrite[1] = tempModelInfo.getTempUvOffset();
                HdPlugin.eightIntWrite[2] = tempModelInfo.getFaceCount();
                this.bufferForTriangles(tempModelInfo.getFaceCount()).ensureCapacity(8).put(eightIntWrite);
                this.targetBufferOffset += tempModelInfo.getFaceCount() * 3;
            }
        }
    }

    @Override
    public boolean drawFace(Model model, int face) {
        return false;
    }

    private GpuIntBuffer bufferForTriangles(int triangles) {
        if (triangles <= 512) {
            ++this.smallModels;
            return this.modelBufferSmall;
        }
        ++this.largeModels;
        return this.modelBuffer;
    }

    private int getScaledValue(double scale, int value) {
        return (int)((double)value * scale + 0.5);
    }

    private void glDpiAwareViewport(int x, int y, int width, int height) {
        if (OSType.getOSType() == OSType.MacOS) {
            GL43C.glViewport(x, y, width, height);
        } else {
            Graphics2D graphics = (Graphics2D)this.canvas.getGraphics();
            if (graphics == null) {
                return;
            }
            AffineTransform t = graphics.getTransform();
            GL43C.glViewport(this.getScaledValue(t.getScaleX(), x), this.getScaledValue(t.getScaleY(), y), this.getScaledValue(t.getScaleX(), width), this.getScaledValue(t.getScaleY(), height));
            graphics.dispose();
        }
    }

    private int getDrawDistance() {
        int limit = 90;
        return Ints.constrainToRange(this.config.drawDistance(), 0, 90);
    }

    public int[] getCameraFocalPoint() {
        int camX = this.client.getOculusOrbFocalPointX();
        int camY = this.client.getOculusOrbFocalPointY();
        int camPitch = this.client.getCameraPitch();
        int minCamPitch = 128;
        int maxCamPitch = 512;
        int camPitchDiff = 384;
        float camHeight = (float)(camPitch - 128) / (float)camPitchDiff;
        int camHeightDiff = 2200;
        int camZ = (int)((float)this.client.getCameraZ() + camHeight * 2200.0f);
        return new int[]{camX, camY, camZ};
    }

    private void updateBuffer(@Nonnull GLBuffer glBuffer, int target, @Nonnull IntBuffer data, int usage, long clFlags) {
        GL43C.glBindBuffer(target, glBuffer.glBufferId);
        int size = data.remaining();
        if (size > glBuffer.size) {
            log.trace("Buffer resize: {} {} -> {}", glBuffer, glBuffer.size, size);
            glBuffer.size = size;
            GL43C.glBufferData(target, data, usage);
            this.recreateCLBuffer(glBuffer, clFlags);
        } else {
            GL43C.glBufferSubData(target, 0L, data);
        }
    }

    private void updateBuffer(@Nonnull GLBuffer glBuffer, int target, @Nonnull FloatBuffer data, int usage, long clFlags) {
        GL43C.glBindBuffer(target, glBuffer.glBufferId);
        int size = data.remaining();
        if (size > glBuffer.size) {
            log.trace("Buffer resize: {} {} -> {}", glBuffer, glBuffer.size, size);
            glBuffer.size = size;
            GL43C.glBufferData(target, data, usage);
            this.recreateCLBuffer(glBuffer, clFlags);
        } else {
            GL43C.glBufferSubData(target, 0L, data);
        }
    }

    private void updateBuffer(@Nonnull GLBuffer glBuffer, int target, @Nonnull ByteBuffer data, int usage, long clFlags) {
        GL43C.glBindBuffer(target, glBuffer.glBufferId);
        int size = data.remaining();
        if (size > glBuffer.size) {
            log.trace("Buffer resize: {} {} -> {}", glBuffer, glBuffer.size, size);
            glBuffer.size = size;
            GL43C.glBufferData(target, data, usage);
            this.recreateCLBuffer(glBuffer, clFlags);
        } else {
            GL43C.glBufferSubData(target, 0L, data);
        }
    }

    private void updateBuffer(@Nonnull GLBuffer glBuffer, int target, int size, int usage, long clFlags) {
        GL43C.glBindBuffer(target, glBuffer.glBufferId);
        if (size > glBuffer.size) {
            log.trace("Buffer resize: {} {} -> {}", glBuffer, glBuffer.size, size);
            glBuffer.size = size;
            GL43C.glBufferData(target, size, usage);
            this.recreateCLBuffer(glBuffer, clFlags);
        }
    }

    private void recreateCLBuffer(GLBuffer glBuffer, long clFlags) {
        if (this.computeMode == ComputeMode.OPENCL) {
            if (glBuffer.cl_mem != null) {
                CL.clReleaseMemObject(glBuffer.cl_mem);
            }
            glBuffer.cl_mem = glBuffer.size == 0 ? null : CL.clCreateFromGLBuffer(this.openCLManager.context, clFlags, glBuffer.glBufferId, null);
        }
    }

    @Subscribe
    public void onProjectileMoved(ProjectileMoved projectileMoved) {
        this.lightManager.addProjectileLight(projectileMoved.getProjectile());
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        this.lightManager.addNpcLights(npcSpawned.getNpc());
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        this.lightManager.removeNpcLight(npcDespawned);
    }

    @Subscribe
    public void onNpcChanged(NpcChanged npcChanged) {
        this.lightManager.updateNpcChanged(npcChanged);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned gameObjectSpawned) {
        GameObject gameObject = gameObjectSpawned.getGameObject();
        this.lightManager.addObjectLight(gameObject, gameObjectSpawned.getTile().getRenderLevel(), gameObject.sizeX(), gameObject.sizeY(), gameObject.getOrientation().getAngle());
    }

    @Subscribe
    public void onGameObjectChanged(GameObjectChanged gameObjectChanged) {
        GameObject previous = gameObjectChanged.getPrevious();
        GameObject gameObject = gameObjectChanged.getGameObject();
        this.lightManager.removeObjectLight(previous);
        this.lightManager.addObjectLight(gameObject, gameObjectChanged.getTile().getRenderLevel(), gameObject.sizeX(), gameObject.sizeY(), gameObject.getOrientation().getAngle());
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned gameObjectDespawned) {
        GameObject gameObject = gameObjectDespawned.getGameObject();
        this.lightManager.removeObjectLight(gameObject);
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned wallObjectSpawned) {
        WallObject wallObject = wallObjectSpawned.getWallObject();
        this.lightManager.addObjectLight(wallObject, wallObjectSpawned.getTile().getRenderLevel(), 1, 1, wallObject.getOrientationA());
    }

    @Subscribe
    public void onWallObjectChanged(WallObjectChanged wallObjectChanged) {
        WallObject previous = wallObjectChanged.getPrevious();
        WallObject wallObject = wallObjectChanged.getWallObject();
        this.lightManager.removeObjectLight(previous);
        this.lightManager.addObjectLight(wallObject, wallObjectChanged.getTile().getRenderLevel(), 1, 1, wallObject.getOrientationA());
    }

    @Subscribe
    public void onWallObjectDespawned(WallObjectDespawned wallObjectDespawned) {
        WallObject wallObject = wallObjectDespawned.getWallObject();
        this.lightManager.removeObjectLight(wallObject);
    }

    @Subscribe
    public void onDecorativeObjectSpawned(DecorativeObjectSpawned decorativeObjectSpawned) {
        DecorativeObject decorativeObject = decorativeObjectSpawned.getDecorativeObject();
        this.lightManager.addObjectLight(decorativeObject, decorativeObjectSpawned.getTile().getRenderLevel());
    }

    @Subscribe
    public void onDecorativeObjectChanged(DecorativeObjectChanged decorativeObjectChanged) {
        DecorativeObject previous = decorativeObjectChanged.getPrevious();
        DecorativeObject decorativeObject = decorativeObjectChanged.getDecorativeObject();
        this.lightManager.removeObjectLight(previous);
        this.lightManager.addObjectLight(decorativeObject, decorativeObjectChanged.getTile().getRenderLevel());
    }

    @Subscribe
    public void onDecorativeObjectDespawned(DecorativeObjectDespawned decorativeObjectDespawned) {
        DecorativeObject decorativeObject = decorativeObjectDespawned.getDecorativeObject();
        this.lightManager.removeObjectLight(decorativeObject);
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned groundObjectSpawned) {
        GroundObject groundObject = groundObjectSpawned.getGroundObject();
        this.lightManager.addObjectLight(groundObject, groundObjectSpawned.getTile().getRenderLevel());
    }

    @Subscribe
    public void onGroundObjectChanged(GroundObjectChanged groundObjectChanged) {
        GroundObject previous = groundObjectChanged.getPrevious();
        GroundObject groundObject = groundObjectChanged.getGroundObject();
        this.lightManager.removeObjectLight(previous);
        this.lightManager.addObjectLight(groundObject, groundObjectChanged.getTile().getRenderLevel());
    }

    @Subscribe
    public void onGroundObjectDespawned(GroundObjectDespawned groundObjectDespawned) {
        GroundObject groundObject = groundObjectDespawned.getGroundObject();
        this.lightManager.removeObjectLight(groundObject);
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (!this.hasLoggedIn && this.client.getGameState() == GameState.LOGGED_IN) {
            this.hasLoggedIn = true;
        }
    }

    private void checkGLErrors() {
        if (!log.isDebugEnabled()) {
            return;
        }
        int err;
        while ((err = GL43C.glGetError()) != 0) {
            String errStr;
            switch (err) {
                case 1280: {
                    errStr = "INVALID_ENUM";
                    break;
                }
                case 1281: {
                    errStr = "INVALID_VALUE";
                    break;
                }
                case 1282: {
                    errStr = "INVALID_OPERATION";
                    break;
                }
                case 1286: {
                    errStr = "INVALID_FRAMEBUFFER_OPERATION";
                    break;
                }
                default: {
                    errStr = "" + err;
                }
            }
            log.debug("glGetError:", new Exception(errStr));
        }
        return;
    }

    public void setNextSceneReload(long nextSceneReload) {
        this.nextSceneReload = nextSceneReload;
    }

    public void setInHouse(boolean isInHouse) {
        this.isInHouse = isInHouse;
    }

    public void setInGauntlet(boolean isInGauntlet) {
        this.isInGauntlet = isInGauntlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ boolean lambda$startUp$0() {
        try {
            if (this.clear) {
                this.clear = false;
                return true;
            }
            if (this.client.getGameState() == GameState.LOGIN_SCREEN) {
                return false;
            }
            this.targetBufferOffset = 0;
            this.rboSceneHandle = -1;
            this.fboSceneHandle = -1;
            this.fboShadowMap = -1;
            this.largeModels = 0;
            this.smallModels = 0;
            this.unorderedModels = 0;
            AWTContext.loadNatives();
            this.canvas = this.client.getCanvas();
            Object object = this.canvas.getTreeLock();
            synchronized (object) {
                if (!this.canvas.isValid()) {
                    return false;
                }
                this.awtContext = new AWTContext(this.canvas);
                this.awtContext.configurePixelFormat(0, 0, 0);
            }
            this.awtContext.createGLContext();
            this.canvas.setIgnoreRepaint(true);
            this.computeMode = OSType.getOSType() == OSType.MacOS ? ComputeMode.OPENCL : ComputeMode.OPENGL;
            GL.createCapabilities();
            log.info("Using device: {}", (Object)GL43C.glGetString(7937));
            log.info("Using driver: {}", (Object)GL43C.glGetString(7938));
            log.info("Client is {}-bit", (Object)System.getProperty("sun.arch.data.model"));
            GLCapabilities caps = GL.getCapabilities();
            if (this.computeMode == ComputeMode.OPENGL) {
                if (!caps.OpenGL43) {
                    throw new RuntimeException("OpenGL 4.3 is required but not available");
                }
            } else if (!caps.OpenGL31) {
                throw new RuntimeException("OpenGL 3.1 is required but not available");
            }
            this.lwjglInitted = true;
            this.checkGLErrors();
            if (log.isDebugEnabled() && caps.glDebugMessageControl != 0L) {
                this.debugCallback = GLUtil.setupDebugMessageCallback();
                if (this.debugCallback != null) {
                    GL43C.glDebugMessageControl(33350, 33361, 4352, 131185, false);
                    GL43C.glDebugMessageControl(33350, 33360, 4352, 131154, false);
                }
            }
            this.vertexBuffer = new GpuIntBuffer();
            this.uvBuffer = new GpuFloatBuffer();
            this.normalBuffer = new GpuFloatBuffer();
            this.modelBufferUnordered = new GpuIntBuffer();
            this.modelBufferSmall = new GpuIntBuffer();
            this.modelBuffer = new GpuIntBuffer();
            if (this.developerMode) {
                this.developerTools.activate();
            }
            this.lastFrameTime = System.currentTimeMillis();
            this.setupSyncMode();
            this.initVao();
            try {
                this.initPrograms();
            }
            catch (ShaderException ex) {
                throw new RuntimeException(ex);
            }
            this.initInterfaceTexture();
            this.initUniformBuffer();
            this.initMaterialsUniformBuffer();
            this.initLightsUniformBuffer();
            this.initBuffers();
            this.initShadowMapFbo();
            this.client.setDrawCallbacks(this);
            this.client.setGpu(true);
            this.client.resizeCanvas();
            this.lastCanvasHeight = -1;
            this.lastCanvasWidth = -1;
            this.lastStretchedCanvasHeight = -1;
            this.lastStretchedCanvasWidth = -1;
            this.lastAntiAliasingMode = null;
            this.textureArrayId = -1;
            this.textureHDArrayId = -1;
            this.lightManager.startUp();
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.uploadScene();
            }
            this.checkGLErrors();
        }
        catch (Throwable e) {
            log.error("Error starting HD plugin", e);
            this.stopPlugin();
        }
        return true;
    }
}

