/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.awt;

import com.jogamp.common.util.awt.AWTEDTExecutor;
import com.jogamp.opengl.GLException;
import java.awt.EventQueue;
import jogamp.opengl.GLWorkerThread;
import jogamp.opengl.ThreadingImpl;
import jogamp.opengl.ToolkitThreadingPlugin;
import jogamp.opengl.awt.Java2D;

public class AWTThreadingPlugin
implements ToolkitThreadingPlugin {
    @Override
    public final boolean isToolkitThread() throws GLException {
        return EventQueue.isDispatchThread();
    }

    @Override
    public final boolean isOpenGLThread() throws GLException {
        switch (ThreadingImpl.getMode()) {
            case ST_AWT: {
                if (Java2D.isOGLPipelineActive() && !ThreadingImpl.isX11()) {
                    return Java2D.isQueueFlusherThread();
                }
                return EventQueue.isDispatchThread();
            }
            case ST_WORKER: {
                if (Java2D.isOGLPipelineActive()) {
                    return Java2D.isQueueFlusherThread() || ThreadingImpl.isX11() && GLWorkerThread.isWorkerThread();
                }
                return GLWorkerThread.isWorkerThread();
            }
        }
        throw new InternalError("Illegal single-threading mode " + (Object)((Object)ThreadingImpl.getMode()));
    }

    @Override
    public final void invokeOnOpenGLThread(boolean bl, Runnable runnable2) throws GLException {
        switch (ThreadingImpl.getMode()) {
            case ST_AWT: {
                if (bl && Java2D.isOGLPipelineActive() && !ThreadingImpl.isX11()) {
                    Java2D.invokeWithOGLContextCurrent(null, runnable2);
                    break;
                }
                AWTEDTExecutor.singleton.invoke(bl, runnable2);
                break;
            }
            case ST_WORKER: {
                ThreadingImpl.invokeOnWorkerThread(bl, runnable2);
                break;
            }
            case MT: {
                runnable2.run();
                break;
            }
            default: {
                throw new InternalError("Illegal single-threading mode " + (Object)((Object)ThreadingImpl.getMode()));
            }
        }
    }
}

