/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.util;

import io.sentry.Hint;
import io.sentry.ILogger;
import io.sentry.hints.ApplyScopeData;
import io.sentry.hints.Cached;
import io.sentry.util.LogUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class HintUtils {
    private HintUtils() {
    }

    @ApiStatus.Internal
    public static Hint createWithTypeCheckHint(Object typeCheckHint) {
        Hint hint = new Hint();
        HintUtils.setTypeCheckHint(hint, typeCheckHint);
        return hint;
    }

    @ApiStatus.Internal
    public static void setTypeCheckHint(@NotNull Hint hint, Object typeCheckHint) {
        hint.set("sentry:typeCheckHint", typeCheckHint);
    }

    @ApiStatus.Internal
    @Nullable
    public static Object getSentrySdkHint(@NotNull Hint hint) {
        return hint.get("sentry:typeCheckHint");
    }

    @ApiStatus.Internal
    public static boolean hasType(@NotNull Hint hint, @NotNull Class<?> clazz) {
        Object sentrySdkHint = HintUtils.getSentrySdkHint(hint);
        return clazz.isInstance(sentrySdkHint);
    }

    @ApiStatus.Internal
    public static <T> void runIfDoesNotHaveType(@NotNull Hint hint, @NotNull Class<T> clazz, SentryNullableConsumer<Object> lambda2) {
        HintUtils.runIfHasType(hint, clazz, ignored -> {}, (value, clazz2) -> lambda2.accept(value));
    }

    @ApiStatus.Internal
    public static <T> void runIfHasType(@NotNull Hint hint, @NotNull Class<T> clazz, SentryConsumer<T> lambda2) {
        HintUtils.runIfHasType(hint, clazz, lambda2, (value, clazz2) -> {});
    }

    @ApiStatus.Internal
    public static <T> void runIfHasTypeLogIfNot(@NotNull Hint hint, @NotNull Class<T> clazz, ILogger logger, SentryConsumer<T> lambda2) {
        HintUtils.runIfHasType(hint, clazz, lambda2, (sentrySdkHint, expectedClass) -> LogUtils.logNotInstanceOf(expectedClass, sentrySdkHint, logger));
    }

    @ApiStatus.Internal
    public static <T> void runIfHasType(@NotNull Hint hint, @NotNull Class<T> clazz, SentryConsumer<T> lambda2, SentryHintFallback fallbackLambda) {
        Object sentrySdkHint = HintUtils.getSentrySdkHint(hint);
        if (HintUtils.hasType(hint, clazz) && sentrySdkHint != null) {
            lambda2.accept(sentrySdkHint);
        } else {
            fallbackLambda.accept(sentrySdkHint, clazz);
        }
    }

    @ApiStatus.Internal
    public static boolean shouldApplyScopeData(@NotNull Hint hint) {
        return !HintUtils.hasType(hint, Cached.class) || HintUtils.hasType(hint, ApplyScopeData.class);
    }

    @FunctionalInterface
    public static interface SentryHintFallback {
        public void accept(@Nullable Object var1, @NotNull Class<?> var2);
    }

    @FunctionalInterface
    public static interface SentryNullableConsumer<T> {
        public void accept(@Nullable T var1);
    }

    @FunctionalInterface
    public static interface SentryConsumer<T> {
        public void accept(@NotNull T var1);
    }
}

