/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.JsonUnknown;
import io.sentry.SentryBaseEvent;
import io.sentry.SentryTracer;
import io.sentry.Span;
import io.sentry.SpanContext;
import io.sentry.SpanStatus;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.MeasurementValue;
import io.sentry.protocol.SentrySpan;
import io.sentry.util.Objects;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryTransaction
extends SentryBaseEvent
implements JsonUnknown,
JsonSerializable {
    @Nullable
    private String transaction;
    @NotNull
    private Double startTimestamp;
    @Nullable
    private Double timestamp;
    @NotNull
    private final List<SentrySpan> spans = new ArrayList<SentrySpan>();
    @NotNull
    private final String type = "transaction";
    @NotNull
    private final @NotNull Map<String, @NotNull MeasurementValue> measurements = new HashMap<String, MeasurementValue>();
    @Nullable
    private Map<String, Object> unknown;

    public SentryTransaction(@NotNull SentryTracer sentryTracer) {
        super(sentryTracer.getEventId());
        Objects.requireNonNull(sentryTracer, "sentryTracer is required");
        this.startTimestamp = DateUtils.dateToSeconds(sentryTracer.getStartTimestamp());
        this.timestamp = sentryTracer.getHighPrecisionTimestamp();
        this.transaction = sentryTracer.getName();
        for (Span span : sentryTracer.getChildren()) {
            if (!Boolean.TRUE.equals(span.isSampled())) continue;
            this.spans.add(new SentrySpan(span));
        }
        Contexts contexts = this.getContexts();
        SpanContext tracerContext = sentryTracer.getSpanContext();
        contexts.setTrace(new SpanContext(tracerContext.getTraceId(), tracerContext.getSpanId(), tracerContext.getParentSpanId(), tracerContext.getOperation(), tracerContext.getDescription(), tracerContext.getSampled(), tracerContext.getStatus()));
        for (Map.Entry<String, String> tag : tracerContext.getTags().entrySet()) {
            this.setTag(tag.getKey(), tag.getValue());
        }
        Map<String, Object> data = sentryTracer.getData();
        if (data != null) {
            for (Map.Entry<String, Object> tag : data.entrySet()) {
                this.setExtra(tag.getKey(), tag.getValue());
            }
        }
    }

    @ApiStatus.Internal
    public SentryTransaction(@Nullable String transaction, @NotNull Double startTimestamp, @Nullable Double timestamp, @NotNull List<SentrySpan> spans, @NotNull @NotNull Map<String, @NotNull MeasurementValue> measurements) {
        this.transaction = transaction;
        this.startTimestamp = startTimestamp;
        this.timestamp = timestamp;
        this.spans.addAll(spans);
        this.measurements.putAll(measurements);
    }

    @NotNull
    public List<SentrySpan> getSpans() {
        return this.spans;
    }

    public boolean isFinished() {
        return this.timestamp != null;
    }

    @Nullable
    public String getTransaction() {
        return this.transaction;
    }

    @NotNull
    public Double getStartTimestamp() {
        return this.startTimestamp;
    }

    @Nullable
    public Double getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public String getType() {
        return "transaction";
    }

    @Nullable
    public SpanStatus getStatus() {
        SpanContext trace = this.getContexts().getTrace();
        return trace != null ? trace.getStatus() : null;
    }

    public boolean isSampled() {
        SpanContext trace = this.getContexts().getTrace();
        return trace != null && Boolean.TRUE.equals(trace.getSampled());
    }

    @NotNull
    public @NotNull Map<String, @NotNull MeasurementValue> getMeasurements() {
        return this.measurements;
    }

    @Override
    public void serialize(@NotNull JsonObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        if (this.transaction != null) {
            writer.name("transaction").value(this.transaction);
        }
        writer.name("start_timestamp").value(logger, this.doubleToBigDecimal(this.startTimestamp));
        if (this.timestamp != null) {
            writer.name("timestamp").value(logger, this.doubleToBigDecimal(this.timestamp));
        }
        if (!this.spans.isEmpty()) {
            writer.name("spans").value(logger, this.spans);
        }
        writer.name("type").value("transaction");
        if (!this.measurements.isEmpty()) {
            writer.name("measurements").value(logger, this.measurements);
        }
        new SentryBaseEvent.Serializer().serialize(this, writer, logger);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        writer.endObject();
    }

    @NotNull
    private BigDecimal doubleToBigDecimal(@NotNull Double value) {
        return BigDecimal.valueOf(value).setScale(6, RoundingMode.DOWN);
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryTransaction> {
        @Override
        @NotNull
        public SentryTransaction deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            reader.beginObject();
            SentryTransaction transaction = new SentryTransaction("", 0.0, null, new ArrayList<SentrySpan>(), new HashMap<String, MeasurementValue>());
            ConcurrentHashMap<String, Object> unknown = null;
            SentryBaseEvent.Deserializer baseEventDeserializer = new SentryBaseEvent.Deserializer();
            block20: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "transaction": {
                        transaction.transaction = reader.nextStringOrNull();
                        break;
                    }
                    case "start_timestamp": {
                        Date date;
                        try {
                            Double deserializedStartTimestamp = reader.nextDoubleOrNull();
                            if (deserializedStartTimestamp == null) continue block20;
                            transaction.startTimestamp = deserializedStartTimestamp;
                        }
                        catch (NumberFormatException e) {
                            date = reader.nextDateOrNull(logger);
                            if (date == null) continue block20;
                            transaction.startTimestamp = DateUtils.dateToSeconds(date);
                        }
                        break;
                    }
                    case "timestamp": {
                        Date date;
                        try {
                            Double deserializedTimestamp = reader.nextDoubleOrNull();
                            if (deserializedTimestamp == null) continue block20;
                            transaction.timestamp = deserializedTimestamp;
                        }
                        catch (NumberFormatException e) {
                            date = reader.nextDateOrNull(logger);
                            if (date == null) continue block20;
                            transaction.timestamp = DateUtils.dateToSeconds(date);
                        }
                        break;
                    }
                    case "spans": {
                        List<SentrySpan> deserializedSpans = reader.nextList(logger, new SentrySpan.Deserializer());
                        if (deserializedSpans == null) continue block20;
                        transaction.spans.addAll(deserializedSpans);
                        break;
                    }
                    case "type": {
                        reader.nextString();
                        break;
                    }
                    case "measurements": {
                        Map deserializedMeasurements = (Map)reader.nextObjectOrNull();
                        if (deserializedMeasurements == null) continue block20;
                        transaction.measurements.putAll(deserializedMeasurements);
                        break;
                    }
                    default: {
                        if (baseEventDeserializer.deserializeValue(transaction, nextName, reader, logger)) continue block20;
                        if (unknown == null) {
                            unknown = new ConcurrentHashMap<String, Object>();
                        }
                        reader.nextUnknown(logger, unknown, nextName);
                    }
                }
            }
            transaction.setUnknown(unknown);
            reader.endObject();
            return transaction;
        }
    }

    public static final class JsonKeys {
        public static final String TRANSACTION = "transaction";
        public static final String START_TIMESTAMP = "start_timestamp";
        public static final String TIMESTAMP = "timestamp";
        public static final String SPANS = "spans";
        public static final String TYPE = "type";
        public static final String MEASUREMENTS = "measurements";
    }
}

