/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.DateUtils;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.NoOpSpan;
import io.sentry.SentryTraceHeader;
import io.sentry.SentryTracer;
import io.sentry.SpanContext;
import io.sentry.SpanFinishedCallback;
import io.sentry.SpanId;
import io.sentry.SpanStatus;
import io.sentry.TraceState;
import io.sentry.TraceStateHeader;
import io.sentry.TransactionContext;
import io.sentry.protocol.SentryId;
import io.sentry.util.Objects;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class Span
implements ISpan {
    @NotNull
    private final Date startTimestamp;
    @Nullable
    private final Long startNanos;
    @Nullable
    private Long endNanos;
    @Nullable
    private Double timestamp;
    @NotNull
    private final SpanContext context;
    @NotNull
    private final SentryTracer transaction;
    @Nullable
    private Throwable throwable;
    @NotNull
    private final IHub hub;
    @NotNull
    private final AtomicBoolean finished = new AtomicBoolean(false);
    @Nullable
    private SpanFinishedCallback spanFinishedCallback;
    @NotNull
    private final Map<String, Object> data = new ConcurrentHashMap<String, Object>();

    Span(@NotNull SentryId traceId, @Nullable SpanId parentSpanId, @NotNull SentryTracer transaction, @NotNull String operation, @NotNull IHub hub) {
        this(traceId, parentSpanId, transaction, operation, hub, null, null);
    }

    Span(@NotNull SentryId traceId, @Nullable SpanId parentSpanId, @NotNull SentryTracer transaction, @NotNull String operation, @NotNull IHub hub, @Nullable Date startTimestamp, @Nullable SpanFinishedCallback spanFinishedCallback) {
        this.context = new SpanContext(traceId, new SpanId(), operation, parentSpanId, transaction.isSampled());
        this.transaction = Objects.requireNonNull(transaction, "transaction is required");
        this.hub = Objects.requireNonNull(hub, "hub is required");
        this.spanFinishedCallback = spanFinishedCallback;
        if (startTimestamp != null) {
            this.startTimestamp = startTimestamp;
            this.startNanos = null;
        } else {
            this.startTimestamp = DateUtils.getCurrentDateTime();
            this.startNanos = System.nanoTime();
        }
    }

    @VisibleForTesting
    public Span(@NotNull TransactionContext context2, @NotNull SentryTracer sentryTracer, @NotNull IHub hub, @Nullable Date startTimestamp) {
        this.context = Objects.requireNonNull(context2, "context is required");
        this.transaction = Objects.requireNonNull(sentryTracer, "sentryTracer is required");
        this.hub = Objects.requireNonNull(hub, "hub is required");
        this.spanFinishedCallback = null;
        if (startTimestamp != null) {
            this.startTimestamp = startTimestamp;
            this.startNanos = null;
        } else {
            this.startTimestamp = DateUtils.getCurrentDateTime();
            this.startNanos = System.nanoTime();
        }
    }

    @NotNull
    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    @Nullable
    public Double getTimestamp() {
        return this.timestamp;
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation) {
        return this.startChild(operation, null);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description, @Nullable Date timestamp) {
        if (this.finished.get()) {
            return NoOpSpan.getInstance();
        }
        return this.transaction.startChild(this.context.getSpanId(), operation, description, timestamp);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description) {
        if (this.finished.get()) {
            return NoOpSpan.getInstance();
        }
        return this.transaction.startChild(this.context.getSpanId(), operation, description);
    }

    @Override
    @NotNull
    public SentryTraceHeader toSentryTrace() {
        return new SentryTraceHeader(this.context.getTraceId(), this.context.getSpanId(), this.context.getSampled());
    }

    @Override
    @Nullable
    public TraceState traceState() {
        return this.transaction.traceState();
    }

    @Override
    @Nullable
    public TraceStateHeader toTraceStateHeader() {
        return this.transaction.toTraceStateHeader();
    }

    @Override
    public void finish() {
        this.finish(this.context.getStatus());
    }

    @Override
    public void finish(@Nullable SpanStatus status) {
        this.finish(status, DateUtils.dateToSeconds(DateUtils.getCurrentDateTime()), null);
    }

    void finish(@Nullable SpanStatus status, @NotNull Double timestamp, @Nullable Long endNanos) {
        if (!this.finished.compareAndSet(false, true)) {
            return;
        }
        this.context.setStatus(status);
        this.timestamp = timestamp;
        if (this.throwable != null) {
            this.hub.setSpanContext(this.throwable, this, this.transaction.getName());
        }
        if (this.spanFinishedCallback != null) {
            this.spanFinishedCallback.execute(this);
        }
        this.endNanos = endNanos == null ? System.nanoTime() : endNanos;
    }

    @Override
    public void setOperation(@NotNull String operation) {
        if (this.finished.get()) {
            return;
        }
        this.context.setOperation(operation);
    }

    @Override
    @NotNull
    public String getOperation() {
        return this.context.getOperation();
    }

    @Override
    public void setDescription(@Nullable String description) {
        if (this.finished.get()) {
            return;
        }
        this.context.setDescription(description);
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.context.getDescription();
    }

    @Override
    public void setStatus(@Nullable SpanStatus status) {
        if (this.finished.get()) {
            return;
        }
        this.context.setStatus(status);
    }

    @Override
    @Nullable
    public SpanStatus getStatus() {
        return this.context.getStatus();
    }

    @Override
    @NotNull
    public SpanContext getSpanContext() {
        return this.context;
    }

    @Override
    public void setTag(@NotNull String key, @NotNull String value) {
        if (this.finished.get()) {
            return;
        }
        this.context.setTag(key, value);
    }

    @Override
    @Nullable
    public String getTag(@NotNull String key) {
        return this.context.getTags().get(key);
    }

    @Override
    public boolean isFinished() {
        return this.finished.get();
    }

    @NotNull
    public Map<String, Object> getData() {
        return this.data;
    }

    @Nullable
    public Boolean isSampled() {
        return this.context.getSampled();
    }

    @Override
    public void setThrowable(@Nullable Throwable throwable) {
        if (this.finished.get()) {
            return;
        }
        this.throwable = throwable;
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        return this.throwable;
    }

    @NotNull
    public SentryId getTraceId() {
        return this.context.getTraceId();
    }

    @NotNull
    public SpanId getSpanId() {
        return this.context.getSpanId();
    }

    @Nullable
    public SpanId getParentSpanId() {
        return this.context.getParentSpanId();
    }

    public Map<String, String> getTags() {
        return this.context.getTags();
    }

    @Override
    public void setData(@NotNull String key, @NotNull Object value) {
        if (this.finished.get()) {
            return;
        }
        this.data.put(key, value);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String key) {
        return this.data.get(key);
    }

    @Nullable
    Long getEndNanos() {
        return this.endNanos;
    }

    void setSpanFinishedCallback(@Nullable SpanFinishedCallback callback) {
        this.spanFinishedCallback = callback;
    }

    @Nullable
    public Double getHighPrecisionTimestamp() {
        return this.getHighPrecisionTimestamp(this.endNanos);
    }

    @Nullable
    Double getHighPrecisionTimestamp(@Nullable Long endNanos) {
        Double duration = this.getDurationInMillis(endNanos);
        if (duration != null) {
            return DateUtils.millisToSeconds((double)this.startTimestamp.getTime() + duration);
        }
        if (this.timestamp != null) {
            return this.timestamp;
        }
        return null;
    }

    @Nullable
    private Double getDurationInMillis(@Nullable Long endNanos) {
        if (this.startNanos != null && endNanos != null) {
            return DateUtils.nanosToMillis(endNanos - this.startNanos);
        }
        return null;
    }
}

