/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.ITransaction;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.JsonUnknown;
import io.sentry.NoOpTransaction;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ProfilingTraceData
implements JsonUnknown,
JsonSerializable {
    @NotNull
    private File traceFile;
    @Nullable
    private Callable<List<Integer>> deviceCpuFrequenciesReader;
    private int androidApiLevel;
    @NotNull
    private String deviceLocale;
    @NotNull
    private String deviceManufacturer;
    @NotNull
    private String deviceModel;
    @NotNull
    private String deviceOsBuildNumber;
    @NotNull
    private String deviceOsName;
    @NotNull
    private String deviceOsVersion;
    private boolean deviceIsEmulator;
    @NotNull
    private List<Integer> deviceCpuFrequencies = new ArrayList<Integer>();
    @NotNull
    private String devicePhysicalMemoryBytes;
    @NotNull
    private String platform;
    @NotNull
    private String buildId;
    @NotNull
    private String transactionName;
    @NotNull
    private String durationNs;
    @NotNull
    private String versionName;
    @NotNull
    private String versionCode;
    @NotNull
    private String transactionId;
    @NotNull
    private String traceId;
    @NotNull
    private String profileId;
    @NotNull
    private String environment;
    @Nullable
    private String sampledProfile = null;
    @Nullable
    private Map<String, Object> unknown;

    private ProfilingTraceData() {
        this(new File("dummy"), NoOpTransaction.getInstance());
    }

    public ProfilingTraceData(@NotNull File traceFile, @NotNull ITransaction transaction) {
        this(traceFile, transaction, "0", 0, () -> new ArrayList(), null, null, null, null, null, null, null, null, null);
    }

    public ProfilingTraceData(@NotNull File traceFile, @NotNull ITransaction transaction, @NotNull String durationNanos, int sdkInt, @NotNull Callable<List<Integer>> deviceCpuFrequenciesReader, @Nullable String deviceManufacturer, @Nullable String deviceModel, @Nullable String deviceOsVersion, @Nullable Boolean deviceIsEmulator, @Nullable String devicePhysicalMemoryBytes, @Nullable String buildId, @Nullable String versionName, @Nullable String versionCode, @Nullable String environment) {
        this.traceFile = traceFile;
        this.deviceCpuFrequenciesReader = deviceCpuFrequenciesReader;
        this.androidApiLevel = sdkInt;
        this.deviceLocale = Locale.getDefault().toString();
        this.deviceManufacturer = deviceManufacturer != null ? deviceManufacturer : "";
        this.deviceModel = deviceModel != null ? deviceModel : "";
        this.deviceOsVersion = deviceOsVersion != null ? deviceOsVersion : "";
        this.deviceIsEmulator = deviceIsEmulator != null ? deviceIsEmulator : false;
        this.devicePhysicalMemoryBytes = devicePhysicalMemoryBytes != null ? devicePhysicalMemoryBytes : "0";
        this.deviceOsBuildNumber = "";
        this.deviceOsName = "android";
        this.platform = "android";
        this.buildId = buildId != null ? buildId : "";
        this.transactionName = transaction.getName();
        this.durationNs = durationNanos;
        this.versionName = versionName != null ? versionName : "";
        this.versionCode = versionCode != null ? versionCode : "";
        this.transactionId = transaction.getEventId().toString();
        this.traceId = transaction.getSpanContext().getTraceId().toString();
        this.profileId = UUID.randomUUID().toString();
        this.environment = environment != null ? environment : "";
    }

    @NotNull
    public File getTraceFile() {
        return this.traceFile;
    }

    public int getAndroidApiLevel() {
        return this.androidApiLevel;
    }

    @NotNull
    public String getDeviceLocale() {
        return this.deviceLocale;
    }

    @NotNull
    public String getDeviceManufacturer() {
        return this.deviceManufacturer;
    }

    @NotNull
    public String getDeviceModel() {
        return this.deviceModel;
    }

    @NotNull
    public String getDeviceOsBuildNumber() {
        return this.deviceOsBuildNumber;
    }

    @NotNull
    public String getDeviceOsName() {
        return this.deviceOsName;
    }

    @NotNull
    public String getDeviceOsVersion() {
        return this.deviceOsVersion;
    }

    public boolean isDeviceIsEmulator() {
        return this.deviceIsEmulator;
    }

    @NotNull
    public String getPlatform() {
        return this.platform;
    }

    @NotNull
    public String getBuildId() {
        return this.buildId;
    }

    @NotNull
    public String getTransactionName() {
        return this.transactionName;
    }

    @NotNull
    public String getVersionName() {
        return this.versionName;
    }

    @NotNull
    public String getVersionCode() {
        return this.versionCode;
    }

    @NotNull
    public String getTransactionId() {
        return this.transactionId;
    }

    @NotNull
    public String getTraceId() {
        return this.traceId;
    }

    @NotNull
    public String getProfileId() {
        return this.profileId;
    }

    @NotNull
    public String getEnvironment() {
        return this.environment;
    }

    @Nullable
    public String getSampledProfile() {
        return this.sampledProfile;
    }

    @NotNull
    public String getDurationNs() {
        return this.durationNs;
    }

    @NotNull
    public List<Integer> getDeviceCpuFrequencies() {
        return this.deviceCpuFrequencies;
    }

    @NotNull
    public String getDevicePhysicalMemoryBytes() {
        return this.devicePhysicalMemoryBytes;
    }

    public void setAndroidApiLevel(int androidApiLevel) {
        this.androidApiLevel = androidApiLevel;
    }

    public void setDeviceLocale(@NotNull String deviceLocale) {
        this.deviceLocale = deviceLocale;
    }

    public void setDeviceManufacturer(@NotNull String deviceManufacturer) {
        this.deviceManufacturer = deviceManufacturer;
    }

    public void setDeviceModel(@NotNull String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public void setDeviceOsBuildNumber(@NotNull String deviceOsBuildNumber) {
        this.deviceOsBuildNumber = deviceOsBuildNumber;
    }

    public void setDeviceOsVersion(@NotNull String deviceOsVersion) {
        this.deviceOsVersion = deviceOsVersion;
    }

    public void setDeviceIsEmulator(boolean deviceIsEmulator) {
        this.deviceIsEmulator = deviceIsEmulator;
    }

    public void setDeviceCpuFrequencies(@NotNull List<Integer> deviceCpuFrequencies) {
        this.deviceCpuFrequencies = deviceCpuFrequencies;
    }

    public void setDevicePhysicalMemoryBytes(@NotNull String devicePhysicalMemoryBytes) {
        this.devicePhysicalMemoryBytes = devicePhysicalMemoryBytes;
    }

    public void setBuildId(@NotNull String buildId) {
        this.buildId = buildId;
    }

    public void setTransactionName(@NotNull String transactionName) {
        this.transactionName = transactionName;
    }

    public void setDurationNs(@NotNull String durationNs) {
        this.durationNs = durationNs;
    }

    public void setVersionName(@NotNull String versionName) {
        this.versionName = versionName;
    }

    public void setVersionCode(@NotNull String versionCode) {
        this.versionCode = versionCode;
    }

    public void setTransactionId(@NotNull String transactionId) {
        this.transactionId = transactionId;
    }

    public void setTraceId(@NotNull String traceId) {
        this.traceId = traceId;
    }

    public void setProfileId(@NotNull String profileId) {
        this.profileId = profileId;
    }

    public void setEnvironment(@NotNull String environment) {
        this.environment = environment;
    }

    public void setSampledProfile(@Nullable String sampledProfile) {
        this.sampledProfile = sampledProfile;
    }

    public void readDeviceCpuFrequencies() {
        try {
            if (this.deviceCpuFrequenciesReader != null) {
                this.deviceCpuFrequencies = this.deviceCpuFrequenciesReader.call();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void serialize(@NotNull JsonObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        writer.name("android_api_level").value(logger, this.androidApiLevel);
        writer.name("device_locale").value(logger, this.deviceLocale);
        writer.name("device_manufacturer").value(this.deviceManufacturer);
        writer.name("device_model").value(this.deviceModel);
        writer.name("device_os_build_number").value(this.deviceOsBuildNumber);
        writer.name("device_os_name").value(this.deviceOsName);
        writer.name("device_os_version").value(this.deviceOsVersion);
        writer.name("device_is_emulator").value(this.deviceIsEmulator);
        writer.name("device_cpu_frequencies").value(logger, this.deviceCpuFrequencies);
        writer.name("device_physical_memory_bytes").value(this.devicePhysicalMemoryBytes);
        writer.name("platform").value(this.platform);
        writer.name("build_id").value(this.buildId);
        writer.name("transaction_name").value(this.transactionName);
        writer.name("duration_ns").value(this.durationNs);
        writer.name("version_name").value(this.versionName);
        writer.name("version_code").value(this.versionCode);
        writer.name("transaction_id").value(this.transactionId);
        writer.name("trace_id").value(this.traceId);
        writer.name("profile_id").value(this.profileId);
        writer.name("environment").value(this.environment);
        if (this.sampledProfile != null) {
            writer.name("sampled_profile").value(this.sampledProfile);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        writer.endObject();
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class Deserializer
    implements JsonDeserializer<ProfilingTraceData> {
        @Override
        @NotNull
        public ProfilingTraceData deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            reader.beginObject();
            ProfilingTraceData data = new ProfilingTraceData();
            ConcurrentHashMap<String, Object> unknown = null;
            block46: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "android_api_level": {
                        Integer apiLevel = reader.nextIntegerOrNull();
                        if (apiLevel == null) continue block46;
                        data.androidApiLevel = apiLevel;
                        continue block46;
                    }
                    case "device_locale": {
                        String deviceLocale = reader.nextStringOrNull();
                        if (deviceLocale == null) continue block46;
                        data.deviceLocale = deviceLocale;
                        continue block46;
                    }
                    case "device_manufacturer": {
                        String deviceManufacturer = reader.nextStringOrNull();
                        if (deviceManufacturer == null) continue block46;
                        data.deviceManufacturer = deviceManufacturer;
                        continue block46;
                    }
                    case "device_model": {
                        String deviceModel = reader.nextStringOrNull();
                        if (deviceModel == null) continue block46;
                        data.deviceModel = deviceModel;
                        continue block46;
                    }
                    case "device_os_build_number": {
                        String deviceOsBuildNumber = reader.nextStringOrNull();
                        if (deviceOsBuildNumber == null) continue block46;
                        data.deviceOsBuildNumber = deviceOsBuildNumber;
                        continue block46;
                    }
                    case "device_os_name": {
                        String deviceOsName = reader.nextStringOrNull();
                        if (deviceOsName == null) continue block46;
                        data.deviceOsName = deviceOsName;
                        continue block46;
                    }
                    case "device_os_version": {
                        String deviceOsVersion = reader.nextStringOrNull();
                        if (deviceOsVersion == null) continue block46;
                        data.deviceOsVersion = deviceOsVersion;
                        continue block46;
                    }
                    case "device_is_emulator": {
                        Boolean deviceIsEmulator = reader.nextBooleanOrNull();
                        if (deviceIsEmulator == null) continue block46;
                        data.deviceIsEmulator = deviceIsEmulator;
                        continue block46;
                    }
                    case "device_cpu_frequencies": {
                        List deviceCpuFrequencies = (List)reader.nextObjectOrNull();
                        if (deviceCpuFrequencies == null) continue block46;
                        data.deviceCpuFrequencies = deviceCpuFrequencies;
                        continue block46;
                    }
                    case "device_physical_memory_bytes": {
                        String devicePhysicalMemoryBytes = reader.nextStringOrNull();
                        if (devicePhysicalMemoryBytes == null) continue block46;
                        data.devicePhysicalMemoryBytes = devicePhysicalMemoryBytes;
                        continue block46;
                    }
                    case "platform": {
                        String platform = reader.nextStringOrNull();
                        if (platform == null) continue block46;
                        data.platform = platform;
                        continue block46;
                    }
                    case "build_id": {
                        String buildId = reader.nextStringOrNull();
                        if (buildId == null) continue block46;
                        data.buildId = buildId;
                        continue block46;
                    }
                    case "transaction_name": {
                        String transactionName = reader.nextStringOrNull();
                        if (transactionName == null) continue block46;
                        data.transactionName = transactionName;
                        continue block46;
                    }
                    case "duration_ns": {
                        String durationNs = reader.nextStringOrNull();
                        if (durationNs == null) continue block46;
                        data.durationNs = durationNs;
                        continue block46;
                    }
                    case "version_name": {
                        String versionName = reader.nextStringOrNull();
                        if (versionName == null) continue block46;
                        data.versionName = versionName;
                        continue block46;
                    }
                    case "version_code": {
                        String versionCode = reader.nextStringOrNull();
                        if (versionCode == null) continue block46;
                        data.versionCode = versionCode;
                        continue block46;
                    }
                    case "transaction_id": {
                        String transactionId = reader.nextStringOrNull();
                        if (transactionId == null) continue block46;
                        data.transactionId = transactionId;
                        continue block46;
                    }
                    case "trace_id": {
                        String traceId = reader.nextStringOrNull();
                        if (traceId == null) continue block46;
                        data.traceId = traceId;
                        continue block46;
                    }
                    case "profile_id": {
                        String profileId = reader.nextStringOrNull();
                        if (profileId == null) continue block46;
                        data.profileId = profileId;
                        continue block46;
                    }
                    case "environment": {
                        String environment = reader.nextStringOrNull();
                        if (environment == null) continue block46;
                        data.environment = environment;
                        continue block46;
                    }
                    case "sampled_profile": {
                        String sampledProfile = reader.nextStringOrNull();
                        if (sampledProfile == null) continue block46;
                        data.sampledProfile = sampledProfile;
                        continue block46;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            data.setUnknown(unknown);
            reader.endObject();
            return data;
        }
    }

    public static final class JsonKeys {
        public static final String ANDROID_API_LEVEL = "android_api_level";
        public static final String DEVICE_LOCALE = "device_locale";
        public static final String DEVICE_MANUFACTURER = "device_manufacturer";
        public static final String DEVICE_MODEL = "device_model";
        public static final String DEVICE_OS_BUILD_NUMBER = "device_os_build_number";
        public static final String DEVICE_OS_NAME = "device_os_name";
        public static final String DEVICE_OS_VERSION = "device_os_version";
        public static final String DEVICE_IS_EMULATOR = "device_is_emulator";
        public static final String DEVICE_CPU_FREQUENCIES = "device_cpu_frequencies";
        public static final String DEVICE_PHYSICAL_MEMORY_BYTES = "device_physical_memory_bytes";
        public static final String PLATFORM = "platform";
        public static final String BUILD_ID = "build_id";
        public static final String TRANSACTION_NAME = "transaction_name";
        public static final String DURATION_NS = "duration_ns";
        public static final String VERSION_NAME = "version_name";
        public static final String VERSION_CODE = "version_code";
        public static final String TRANSACTION_ID = "transaction_id";
        public static final String TRACE_ID = "trace_id";
        public static final String PROFILE_ID = "profile_id";
        public static final String ENVIRONMENT = "environment";
        public static final String SAMPLED_PROFILE = "sampled_profile";
    }
}

