/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.NoOpSpan;
import io.sentry.SentryTraceHeader;
import io.sentry.Span;
import io.sentry.SpanContext;
import io.sentry.SpanId;
import io.sentry.SpanStatus;
import io.sentry.TraceState;
import io.sentry.TraceStateHeader;
import io.sentry.protocol.SentryId;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NoOpTransaction
implements ITransaction {
    private static final NoOpTransaction instance = new NoOpTransaction();

    private NoOpTransaction() {
    }

    public static NoOpTransaction getInstance() {
        return instance;
    }

    @Override
    public void setName(@NotNull String name) {
    }

    @Override
    @NotNull
    public String getName() {
        return "";
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation) {
        return NoOpSpan.getInstance();
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description, @Nullable Date timestamp) {
        return NoOpSpan.getInstance();
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description) {
        return NoOpSpan.getInstance();
    }

    @Override
    @Nullable
    public String getDescription() {
        return null;
    }

    @Override
    @NotNull
    public List<Span> getSpans() {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public Span getLatestActiveSpan() {
        return null;
    }

    @Override
    @NotNull
    public SentryId getEventId() {
        return SentryId.EMPTY_ID;
    }

    @Override
    public void scheduleFinish(@NotNull Long idleTimeout) {
    }

    @Override
    public boolean isFinished() {
        return true;
    }

    @Override
    @NotNull
    public SentryTraceHeader toSentryTrace() {
        return new SentryTraceHeader(SentryId.EMPTY_ID, SpanId.EMPTY_ID, false);
    }

    @Override
    @NotNull
    public TraceState traceState() {
        return new TraceState(SentryId.EMPTY_ID, "");
    }

    @Override
    @NotNull
    public TraceStateHeader toTraceStateHeader() {
        return new TraceStateHeader("");
    }

    @Override
    public void finish() {
    }

    @Override
    public void finish(@Nullable SpanStatus status) {
    }

    @Override
    public void setOperation(@NotNull String operation) {
    }

    @Override
    @NotNull
    public String getOperation() {
        return "";
    }

    @Override
    public void setDescription(@Nullable String description) {
    }

    @Override
    public void setStatus(@Nullable SpanStatus status) {
    }

    @Override
    @Nullable
    public SpanStatus getStatus() {
        return null;
    }

    @Override
    public void setThrowable(@Nullable Throwable throwable) {
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        return null;
    }

    @Override
    @NotNull
    public SpanContext getSpanContext() {
        return new SpanContext(SentryId.EMPTY_ID, SpanId.EMPTY_ID, "op", null, null);
    }

    @Override
    public void setTag(@NotNull String key, @NotNull String value) {
    }

    @Override
    @Nullable
    public String getTag(@NotNull String key) {
        return null;
    }

    @Override
    @Nullable
    public Boolean isSampled() {
        return null;
    }

    @Override
    public void setData(@NotNull String key, @NotNull Object value) {
    }

    @Override
    @Nullable
    public Object getData(@NotNull String key) {
        return null;
    }
}

