/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.HostnameCache;
import io.sentry.SentryBaseEvent;
import io.sentry.SentryEvent;
import io.sentry.SentryExceptionFactory;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryStackTraceFactory;
import io.sentry.SentryThreadFactory;
import io.sentry.hints.Cached;
import io.sentry.protocol.DebugImage;
import io.sentry.protocol.DebugMeta;
import io.sentry.protocol.SentryException;
import io.sentry.protocol.SentryTransaction;
import io.sentry.protocol.User;
import io.sentry.util.HintUtils;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class MainEventProcessor
implements EventProcessor,
Closeable {
    private static final String DEFAULT_ENVIRONMENT = "production";
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final SentryThreadFactory sentryThreadFactory;
    @NotNull
    private final SentryExceptionFactory sentryExceptionFactory;
    @Nullable
    private final HostnameCache hostnameCache;

    public MainEventProcessor(@NotNull SentryOptions options) {
        this(options, options.isAttachServerName() ? HostnameCache.getInstance() : null);
    }

    MainEventProcessor(@NotNull SentryOptions options, @Nullable HostnameCache hostnameCache) {
        this.options = Objects.requireNonNull(options, "The SentryOptions is required.");
        this.hostnameCache = hostnameCache;
        SentryStackTraceFactory sentryStackTraceFactory = new SentryStackTraceFactory(this.options.getInAppExcludes(), this.options.getInAppIncludes());
        this.sentryExceptionFactory = new SentryExceptionFactory(sentryStackTraceFactory);
        this.sentryThreadFactory = new SentryThreadFactory(sentryStackTraceFactory, this.options);
    }

    MainEventProcessor(@NotNull SentryOptions options, @NotNull SentryThreadFactory sentryThreadFactory, @NotNull SentryExceptionFactory sentryExceptionFactory, @NotNull HostnameCache hostnameCache) {
        this.options = Objects.requireNonNull(options, "The SentryOptions is required.");
        this.sentryThreadFactory = Objects.requireNonNull(sentryThreadFactory, "The SentryThreadFactory is required.");
        this.sentryExceptionFactory = Objects.requireNonNull(sentryExceptionFactory, "The SentryExceptionFactory is required.");
        this.hostnameCache = Objects.requireNonNull(hostnameCache, "The HostnameCache is required");
    }

    @Override
    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        this.setCommons(event);
        this.setExceptions(event);
        this.setDebugMeta(event);
        if (this.shouldApplyScopeData(event, hint)) {
            this.processNonCachedEvent(event);
            this.setThreads(event, hint);
        }
        return event;
    }

    private void setDebugMeta(@NotNull SentryEvent event) {
        if (this.options.getProguardUuid() != null) {
            List<DebugImage> images;
            DebugMeta debugMeta = event.getDebugMeta();
            if (debugMeta == null) {
                debugMeta = new DebugMeta();
            }
            if (debugMeta.getImages() == null) {
                debugMeta.setImages(new ArrayList<DebugImage>());
            }
            if ((images = debugMeta.getImages()) != null) {
                DebugImage debugImage = new DebugImage();
                debugImage.setType("proguard");
                debugImage.setUuid(this.options.getProguardUuid());
                images.add(debugImage);
                event.setDebugMeta(debugMeta);
            }
        }
    }

    private boolean shouldApplyScopeData(@NotNull SentryBaseEvent event, @NotNull Hint hint) {
        if (HintUtils.shouldApplyScopeData(hint)) {
            return true;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Event was cached so not applying data relevant to the current app execution/version: %s", event.getEventId());
        return false;
    }

    private void processNonCachedEvent(@NotNull SentryBaseEvent event) {
        this.setRelease(event);
        this.setEnvironment(event);
        this.setServerName(event);
        this.setDist(event);
        this.setSdk(event);
        this.setTags(event);
        this.mergeUser(event);
    }

    @Override
    @NotNull
    public SentryTransaction process(@NotNull SentryTransaction transaction, @NotNull Hint hint) {
        this.setCommons(transaction);
        if (this.shouldApplyScopeData(transaction, hint)) {
            this.processNonCachedEvent(transaction);
        }
        return transaction;
    }

    private void setCommons(@NotNull SentryBaseEvent event) {
        this.setPlatform(event);
    }

    private void setPlatform(@NotNull SentryBaseEvent event) {
        if (event.getPlatform() == null) {
            event.setPlatform("java");
        }
    }

    private void setRelease(@NotNull SentryBaseEvent event) {
        if (event.getRelease() == null) {
            event.setRelease(this.options.getRelease());
        }
    }

    private void setEnvironment(@NotNull SentryBaseEvent event) {
        if (event.getEnvironment() == null) {
            event.setEnvironment(this.options.getEnvironment() != null ? this.options.getEnvironment() : DEFAULT_ENVIRONMENT);
        }
    }

    private void setServerName(@NotNull SentryBaseEvent event) {
        if (event.getServerName() == null) {
            event.setServerName(this.options.getServerName());
        }
        if (this.options.isAttachServerName() && this.hostnameCache != null && event.getServerName() == null) {
            event.setServerName(this.hostnameCache.getHostname());
        }
    }

    private void setDist(@NotNull SentryBaseEvent event) {
        if (event.getDist() == null) {
            event.setDist(this.options.getDist());
        }
    }

    private void setSdk(@NotNull SentryBaseEvent event) {
        if (event.getSdk() == null) {
            event.setSdk(this.options.getSdkVersion());
        }
    }

    private void setTags(@NotNull SentryBaseEvent event) {
        if (event.getTags() == null) {
            event.setTags(new HashMap<String, String>(this.options.getTags()));
        } else {
            for (Map.Entry<String, String> item : this.options.getTags().entrySet()) {
                if (event.getTags().containsKey(item.getKey())) continue;
                event.setTag(item.getKey(), item.getValue());
            }
        }
    }

    private void mergeUser(@NotNull SentryBaseEvent event) {
        if (this.options.isSendDefaultPii()) {
            if (event.getUser() == null) {
                User user = new User();
                user.setIpAddress("{{auto}}");
                event.setUser(user);
            } else if (event.getUser().getIpAddress() == null) {
                event.getUser().setIpAddress("{{auto}}");
            }
        }
    }

    private void setExceptions(@NotNull SentryEvent event) {
        Throwable throwable = event.getThrowableMechanism();
        if (throwable != null) {
            event.setExceptions(this.sentryExceptionFactory.getSentryExceptions(throwable));
        }
    }

    private void setThreads(@NotNull SentryEvent event, @NotNull Hint hint) {
        if (event.getThreads() == null) {
            ArrayList<Long> mechanismThreadIds = null;
            List<SentryException> eventExceptions = event.getExceptions();
            if (eventExceptions != null && !eventExceptions.isEmpty()) {
                for (SentryException item : eventExceptions) {
                    if (item.getMechanism() == null || item.getThreadId() == null) continue;
                    if (mechanismThreadIds == null) {
                        mechanismThreadIds = new ArrayList<Long>();
                    }
                    mechanismThreadIds.add(item.getThreadId());
                }
            }
            if (this.options.isAttachThreads()) {
                event.setThreads(this.sentryThreadFactory.getCurrentThreads(mechanismThreadIds));
            } else if (this.options.isAttachStacktrace() && (eventExceptions == null || eventExceptions.isEmpty()) && !this.isCachedHint(hint)) {
                event.setThreads(this.sentryThreadFactory.getCurrentThread());
            }
        }
    }

    private boolean isCachedHint(@NotNull Hint hint) {
        return HintUtils.hasType(hint, Cached.class);
    }

    @Override
    public void close() throws IOException {
        if (this.hostnameCache != null) {
            this.hostnameCache.close();
        }
    }

    boolean isClosed() {
        if (this.hostnameCache != null) {
            return this.hostnameCache.isClosed();
        }
        return true;
    }

    @VisibleForTesting
    @Nullable
    HostnameCache getHostnameCache() {
        return this.hostnameCache;
    }
}

