/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Attachment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Hint {
    @NotNull
    private static final Map<String, Class<?>> PRIMITIVE_MAPPINGS = new HashMap();
    @NotNull
    private final Map<String, Object> internalStorage = new HashMap<String, Object>();
    @NotNull
    private final List<Attachment> attachments = new ArrayList<Attachment>();
    @Nullable
    private Attachment screenshot = null;

    @NotNull
    public static Hint withAttachment(@Nullable Attachment attachment) {
        @NotNull Hint hint = new Hint();
        hint.addAttachment(attachment);
        return hint;
    }

    @NotNull
    public static Hint withAttachments(@Nullable List<Attachment> attachments) {
        @NotNull Hint hint = new Hint();
        hint.addAttachments(attachments);
        return hint;
    }

    public void set(@NotNull String name, @Nullable Object hint) {
        this.internalStorage.put(name, hint);
    }

    @Nullable
    public Object get(@NotNull String name) {
        return this.internalStorage.get(name);
    }

    @Nullable
    public <T> T getAs(@NotNull String name, @NotNull Class<T> clazz) {
        Object hintValue = this.internalStorage.get(name);
        if (clazz.isInstance(hintValue)) {
            return (T)hintValue;
        }
        if (this.isCastablePrimitive(hintValue, clazz)) {
            return (T)hintValue;
        }
        return null;
    }

    public void remove(@NotNull String name) {
        this.internalStorage.remove(name);
    }

    public void addAttachment(@Nullable Attachment attachment) {
        if (attachment != null) {
            this.attachments.add(attachment);
        }
    }

    public void addAttachments(@Nullable List<Attachment> attachments) {
        if (attachments != null) {
            this.attachments.addAll(attachments);
        }
    }

    @NotNull
    public List<Attachment> getAttachments() {
        return new ArrayList<Attachment>(this.attachments);
    }

    public void replaceAttachments(@Nullable List<Attachment> attachments) {
        this.clearAttachments();
        this.addAttachments(attachments);
    }

    public void clearAttachments() {
        this.attachments.clear();
    }

    public void setScreenshot(@Nullable Attachment screenshot) {
        this.screenshot = screenshot;
    }

    @Nullable
    public Attachment getScreenshot() {
        return this.screenshot;
    }

    private boolean isCastablePrimitive(@Nullable Object hintValue, @NotNull Class<?> clazz) {
        Class<?> nonPrimitiveClass = PRIMITIVE_MAPPINGS.get(clazz.getCanonicalName());
        return hintValue != null && clazz.isPrimitive() && nonPrimitiveClass != null && nonPrimitiveClass.isInstance(hintValue);
    }

    static {
        PRIMITIVE_MAPPINGS.put("boolean", Boolean.class);
        PRIMITIVE_MAPPINGS.put("char", Character.class);
        PRIMITIVE_MAPPINGS.put("byte", Byte.class);
        PRIMITIVE_MAPPINGS.put("short", Short.class);
        PRIMITIVE_MAPPINGS.put("int", Integer.class);
        PRIMITIVE_MAPPINGS.put("long", Long.class);
        PRIMITIVE_MAPPINGS.put("float", Float.class);
        PRIMITIVE_MAPPINGS.put("double", Double.class);
    }
}

