/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.JsonUnknown;
import io.sentry.SentryLevel;
import io.sentry.util.CollectionUtils;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Breadcrumb
implements JsonUnknown,
JsonSerializable {
    @NotNull
    private final Date timestamp;
    @Nullable
    private String message;
    @Nullable
    private String type;
    @NotNull
    private @NotNull Map<String, @NotNull Object> data = new ConcurrentHashMap<String, Object>();
    @Nullable
    private String category;
    @Nullable
    private SentryLevel level;
    @Nullable
    private Map<String, Object> unknown;

    public Breadcrumb(@NotNull Date timestamp) {
        this.timestamp = timestamp;
    }

    Breadcrumb(@NotNull Breadcrumb breadcrumb) {
        this.timestamp = breadcrumb.timestamp;
        this.message = breadcrumb.message;
        this.type = breadcrumb.type;
        this.category = breadcrumb.category;
        Map<String, Object> dataClone = CollectionUtils.newConcurrentHashMap(breadcrumb.data);
        if (dataClone != null) {
            this.data = dataClone;
        }
        this.unknown = CollectionUtils.newConcurrentHashMap(breadcrumb.unknown);
        this.level = breadcrumb.level;
    }

    @NotNull
    public static Breadcrumb http(@NotNull String url, @NotNull String method) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("http");
        breadcrumb.setCategory("http");
        breadcrumb.setData("url", url);
        breadcrumb.setData("method", method.toUpperCase(Locale.ROOT));
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb http(@NotNull String url, @NotNull String method, @Nullable Integer code) {
        Breadcrumb breadcrumb = Breadcrumb.http(url, method);
        if (code != null) {
            breadcrumb.setData("status_code", code);
        }
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb navigation(@NotNull String from, @NotNull String to) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setCategory("navigation");
        breadcrumb.setType("navigation");
        breadcrumb.setData("from", from);
        breadcrumb.setData("to", to);
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb transaction(@NotNull String message) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("default");
        breadcrumb.setCategory("sentry.transaction");
        breadcrumb.setMessage(message);
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb debug(@NotNull String message) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("debug");
        breadcrumb.setMessage(message);
        breadcrumb.setLevel(SentryLevel.DEBUG);
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb error(@NotNull String message) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("error");
        breadcrumb.setMessage(message);
        breadcrumb.setLevel(SentryLevel.ERROR);
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb info(@NotNull String message) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("info");
        breadcrumb.setMessage(message);
        breadcrumb.setLevel(SentryLevel.INFO);
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb query(@NotNull String message) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("query");
        breadcrumb.setMessage(message);
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb ui(@NotNull String category, @NotNull String message) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("default");
        breadcrumb.setCategory("ui." + category);
        breadcrumb.setMessage(message);
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb user(@NotNull String category, @NotNull String message) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("user");
        breadcrumb.setCategory(category);
        breadcrumb.setMessage(message);
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb userInteraction(@NotNull String subCategory, @Nullable String viewId, @Nullable String viewClass) {
        return Breadcrumb.userInteraction(subCategory, viewId, viewClass, Collections.emptyMap());
    }

    @NotNull
    public static Breadcrumb userInteraction(@NotNull String subCategory, @Nullable String viewId, @Nullable String viewClass, @NotNull Map<String, Object> additionalData) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("user");
        breadcrumb.setCategory("ui." + subCategory);
        if (viewId != null) {
            breadcrumb.setData("view.id", viewId);
        }
        if (viewClass != null) {
            breadcrumb.setData("view.class", viewClass);
        }
        for (Map.Entry<String, Object> entry : additionalData.entrySet()) {
            breadcrumb.getData().put(entry.getKey(), entry.getValue());
        }
        breadcrumb.setLevel(SentryLevel.INFO);
        return breadcrumb;
    }

    public Breadcrumb() {
        this(DateUtils.getCurrentDateTime());
    }

    public Breadcrumb(@Nullable String message) {
        this();
        this.message = message;
    }

    @NotNull
    public Date getTimestamp() {
        return (Date)this.timestamp.clone();
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable String message) {
        this.message = message;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setType(@Nullable String type) {
        this.type = type;
    }

    @ApiStatus.Internal
    @NotNull
    public Map<String, Object> getData() {
        return this.data;
    }

    @Nullable
    public Object getData(@NotNull String key) {
        return this.data.get(key);
    }

    public void setData(@NotNull String key, @NotNull Object value) {
        this.data.put(key, value);
    }

    public void removeData(@NotNull String key) {
        this.data.remove(key);
    }

    @Nullable
    public String getCategory() {
        return this.category;
    }

    public void setCategory(@Nullable String category) {
        this.category = category;
    }

    @Nullable
    public SentryLevel getLevel() {
        return this.level;
    }

    public void setLevel(@Nullable SentryLevel level) {
        this.level = level;
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull JsonObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        writer.name("timestamp").value(logger, this.timestamp);
        if (this.message != null) {
            writer.name("message").value(this.message);
        }
        if (this.type != null) {
            writer.name("type").value(this.type);
        }
        writer.name("data").value(logger, this.data);
        if (this.category != null) {
            writer.name("category").value(this.category);
        }
        if (this.level != null) {
            writer.name("level").value(logger, this.level);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        writer.endObject();
    }

    public static final class Deserializer
    implements JsonDeserializer<Breadcrumb> {
        @Override
        @NotNull
        public Breadcrumb deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            reader.beginObject();
            @NotNull Date timestamp = DateUtils.getCurrentDateTime();
            String message = null;
            String type = null;
            @NotNull Map<K, V> data = new ConcurrentHashMap();
            String category = null;
            SentryLevel level = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block18: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "timestamp": {
                        Date deserializedDate = reader.nextDateOrNull(logger);
                        if (deserializedDate == null) continue block18;
                        timestamp = deserializedDate;
                        continue block18;
                    }
                    case "message": {
                        message = reader.nextStringOrNull();
                        continue block18;
                    }
                    case "type": {
                        type = reader.nextStringOrNull();
                        continue block18;
                    }
                    case "data": {
                        Map deserializedData = CollectionUtils.newConcurrentHashMap((Map)reader.nextObjectOrNull());
                        if (deserializedData == null) continue block18;
                        data = deserializedData;
                        continue block18;
                    }
                    case "category": {
                        category = reader.nextStringOrNull();
                        continue block18;
                    }
                    case "level": {
                        try {
                            level = new SentryLevel.Deserializer().deserialize(reader, logger);
                        }
                        catch (Exception exception) {
                            logger.log(SentryLevel.ERROR, exception, "Error when deserializing SentryLevel", new Object[0]);
                        }
                        continue block18;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            Breadcrumb breadcrumb = new Breadcrumb(timestamp);
            breadcrumb.message = message;
            breadcrumb.type = type;
            breadcrumb.data = data;
            breadcrumb.category = category;
            breadcrumb.level = level;
            breadcrumb.setUnknown(unknown);
            reader.endObject();
            return breadcrumb;
        }
    }

    public static final class JsonKeys {
        public static final String TIMESTAMP = "timestamp";
        public static final String MESSAGE = "message";
        public static final String TYPE = "type";
        public static final String DATA = "data";
        public static final String CATEGORY = "category";
        public static final String LEVEL = "level";
    }
}

