/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractBackpressureThrottlingSubscriber;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import java.util.Objects;
import org.reactivestreams.Subscriber;

public final class FlowableOnBackpressureReduceWith<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final BiFunction<R, ? super T, R> reducer;
    final Supplier<R> supplier;

    public FlowableOnBackpressureReduceWith(@NonNull Flowable<T> source2, @NonNull Supplier<R> supplier, @NonNull BiFunction<R, ? super T, R> reducer) {
        super(source2);
        this.reducer = reducer;
        this.supplier = supplier;
    }

    @Override
    protected void subscribeActual(@NonNull Subscriber<? super R> s2) {
        this.source.subscribe(new BackpressureReduceWithSubscriber<T, R>(s2, this.supplier, this.reducer));
    }

    static final class BackpressureReduceWithSubscriber<T, R>
    extends AbstractBackpressureThrottlingSubscriber<T, R> {
        private static final long serialVersionUID = 8255923705960622424L;
        final BiFunction<R, ? super T, R> reducer;
        final Supplier<R> supplier;

        BackpressureReduceWithSubscriber(@NonNull Subscriber<? super R> downstream, @NonNull Supplier<R> supplier, @NonNull BiFunction<R, ? super T, R> reducer) {
            super(downstream);
            this.reducer = reducer;
            this.supplier = supplier;
        }

        @Override
        public void onNext(T t) {
            Object v = this.current.get();
            if (v != null) {
                v = this.current.getAndSet(null);
            }
            try {
                if (v == null) {
                    this.current.lazySet(Objects.requireNonNull(this.reducer.apply(Objects.requireNonNull(this.supplier.get(), "The supplier returned a null value"), t), "The reducer returned a null value"));
                } else {
                    this.current.lazySet(Objects.requireNonNull(this.reducer.apply(v, t), "The reducer returned a null value"));
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.upstream.cancel();
                this.onError(ex);
                return;
            }
            this.drain();
        }
    }
}

