/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxrelay3;

import com.jakewharton.rxrelay3.AppendOnlyLinkedArrayList;
import com.jakewharton.rxrelay3.Relay;
import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import java.lang.reflect.Array;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class BehaviorRelay<T>
extends Relay<T> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    final AtomicReference<T> value;
    final AtomicReference<BehaviorDisposable<T>[]> subscribers;
    static final BehaviorDisposable[] EMPTY = new BehaviorDisposable[0];
    final Lock readLock;
    final Lock writeLock;
    long index;

    @CheckReturnValue
    @NonNull
    public static <T> BehaviorRelay<T> create() {
        return new BehaviorRelay<T>();
    }

    @CheckReturnValue
    @NonNull
    public static <T> BehaviorRelay<T> createDefault(@NonNull T defaultValue) {
        return new BehaviorRelay<T>(defaultValue);
    }

    BehaviorRelay() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.subscribers = new AtomicReference<BehaviorDisposable[]>(EMPTY);
        this.value = new AtomicReference();
    }

    BehaviorRelay(@NonNull T defaultValue) {
        this();
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue == null");
        }
        this.value.lazySet(defaultValue);
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        BehaviorDisposable<T> bs = new BehaviorDisposable<T>(observer, this);
        observer.onSubscribe(bs);
        this.add(bs);
        if (bs.cancelled) {
            this.remove(bs);
        } else {
            bs.emitFirst();
        }
    }

    @Override
    public void accept(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        this.setCurrent(value);
        for (BehaviorDisposable<T> bs : this.subscribers.get()) {
            bs.emitNext(value, this.index);
        }
    }

    @Override
    public boolean hasObservers() {
        return this.subscribers.get().length != 0;
    }

    int subscriberCount() {
        return this.subscribers.get().length;
    }

    @Nullable
    public T getValue() {
        return this.value.get();
    }

    @Deprecated
    public Object[] getValues() {
        Object[] a = EMPTY_ARRAY;
        Object[] b = this.getValues(a);
        if (b == EMPTY_ARRAY) {
            return new Object[0];
        }
        return b;
    }

    @Deprecated
    public T[] getValues(T[] array) {
        T o = this.value.get();
        if (o == null) {
            if (array.length != 0) {
                array[0] = null;
            }
            return array;
        }
        if (array.length != 0) {
            array[0] = o;
            if (array.length != 1) {
                array[1] = null;
            }
        } else {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), 1);
            array[0] = o;
        }
        return array;
    }

    public boolean hasValue() {
        return this.value.get() != null;
    }

    void add(BehaviorDisposable<T> rs) {
        BehaviorDisposable[] b;
        BehaviorDisposable<T>[] a;
        do {
            a = this.subscribers.get();
            int len = a.length;
            b = new BehaviorDisposable[len + 1];
            System.arraycopy(a, 0, b, 0, len);
            b[len] = rs;
        } while (!this.subscribers.compareAndSet(a, b));
    }

    void remove(BehaviorDisposable<T> rs) {
        BehaviorDisposable[] b;
        BehaviorDisposable<T>[] a;
        do {
            int len;
            if ((len = (a = this.subscribers.get()).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < len; ++i) {
                if (a[i] != rs) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (len == 1) {
                b = EMPTY;
                continue;
            }
            b = new BehaviorDisposable[len - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, len - j - 1);
        } while (!this.subscribers.compareAndSet(a, b));
    }

    void setCurrent(@NonNull T o) {
        this.writeLock.lock();
        ++this.index;
        this.value.lazySet(o);
        this.writeLock.unlock();
    }

    static final class BehaviorDisposable<T>
    implements Disposable,
    AppendOnlyLinkedArrayList.NonThrowingPredicate<T> {
        final Observer<? super T> downstream;
        final BehaviorRelay<T> state;
        boolean next;
        boolean emitting;
        AppendOnlyLinkedArrayList<T> queue;
        boolean fastPath;
        volatile boolean cancelled;
        long index;

        BehaviorDisposable(Observer<? super T> actual, BehaviorRelay<T> state) {
            this.downstream = actual;
            this.state = state;
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitFirst() {
            Object o;
            if (this.cancelled) {
                return;
            }
            BehaviorDisposable behaviorDisposable = this;
            synchronized (behaviorDisposable) {
                if (this.cancelled) {
                    return;
                }
                if (this.next) {
                    return;
                }
                BehaviorRelay<T> s2 = this.state;
                Lock lock = s2.readLock;
                lock.lock();
                this.index = s2.index;
                o = s2.value.get();
                lock.unlock();
                this.emitting = o != null;
                this.next = true;
            }
            if (o != null) {
                this.test(o);
                this.emitLoop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitNext(T value, long stateIndex) {
            if (this.cancelled) {
                return;
            }
            if (!this.fastPath) {
                BehaviorDisposable behaviorDisposable = this;
                synchronized (behaviorDisposable) {
                    if (this.cancelled) {
                        return;
                    }
                    if (this.index == stateIndex) {
                        return;
                    }
                    if (this.emitting) {
                        AppendOnlyLinkedArrayList<T> q = this.queue;
                        if (q == null) {
                            q = new AppendOnlyLinkedArrayList(4);
                            this.queue = q;
                        }
                        q.add(value);
                        return;
                    }
                    this.next = true;
                }
                this.fastPath = true;
            }
            this.test(value);
        }

        @Override
        public boolean test(T o) {
            if (!this.cancelled) {
                this.downstream.onNext(o);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitLoop() {
            while (!this.cancelled) {
                AppendOnlyLinkedArrayList<T> q;
                BehaviorDisposable behaviorDisposable = this;
                synchronized (behaviorDisposable) {
                    q = this.queue;
                    if (q == null) {
                        this.emitting = false;
                        return;
                    }
                    this.queue = null;
                }
                q.forEachWhile(this);
            }
            return;
        }
    }
}

